@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Sensor integration request model.
 * @property enabled Sensor integration enable state.
 * @property provisioningInfo Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
 * @property provisioningState Sensor integration instance provisioning state.
 */
public data class SensorIntegrationResponse(
    public val enabled: String? = null,
    public val provisioningInfo: ErrorResponseResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.SensorIntegrationResponse): SensorIntegrationResponse = SensorIntegrationResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            provisioningInfo = javaType.provisioningInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.agfoodplatform.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
