@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Solution resource properties.
 * @property marketplacePublisherId SaaS application Marketplace Publisher Id.
 * @property offerId SaaS application Offer Id.
 * @property partnerId Partner Id of the Solution.
 * @property planId SaaS application Plan Id.
 * @property roleAssignmentId Role Assignment Id.
 * @property saasSubscriptionId SaaS subscriptionId of the installed SaaS application.
 * @property saasSubscriptionName SaaS subscription name of the installed SaaS application.
 * @property termId SaaS application Term Id.
 */
public data class SolutionPropertiesResponse(
    public val marketplacePublisherId: String,
    public val offerId: String,
    public val partnerId: String,
    public val planId: String,
    public val roleAssignmentId: String? = null,
    public val saasSubscriptionId: String,
    public val saasSubscriptionName: String,
    public val termId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.SolutionPropertiesResponse): SolutionPropertiesResponse = SolutionPropertiesResponse(
            marketplacePublisherId = javaType.marketplacePublisherId(),
            offerId = javaType.offerId(),
            partnerId = javaType.partnerId(),
            planId = javaType.planId(),
            roleAssignmentId = javaType.roleAssignmentId().map({ args0 -> args0 }).orElse(null),
            saasSubscriptionId = javaType.saasSubscriptionId(),
            saasSubscriptionName = javaType.saasSubscriptionName(),
            termId = javaType.termId(),
        )
    }
}
