@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin

import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.PrometheusRuleResponse
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.PrometheusRuleResponse.Companion.toKotlin as prometheusRuleResponseToKotlin
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrometheusRuleGroup].
 */
@PulumiTagMarker
public class PrometheusRuleGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrometheusRuleGroupArgs = PrometheusRuleGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrometheusRuleGroupArgsBuilder.() -> Unit) {
        val builder = PrometheusRuleGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrometheusRuleGroup {
        val builtJavaResource =
            com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrometheusRuleGroup(builtJavaResource)
    }
}

/**
 * The Prometheus rule group resource.
 * Azure REST API version: 2023-03-01.
 * ## Example Usage
 * ### Create or Update a PrometheusRuleGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prometheusRuleGroup = new AzureNative.AlertsManagement.PrometheusRuleGroup("prometheusRuleGroup", new()
 *     {
 *         ClusterName = "myClusterName",
 *         Description = "This is the description of the following rule group",
 *         Enabled = true,
 *         Interval = "PT10M",
 *         Location = "East US",
 *         ResourceGroupName = "promResourceGroup",
 *         RuleGroupName = "myPrometheusRuleGroup",
 *         Rules = new[]
 *         {
 *             new AzureNative.AlertsManagement.Inputs.PrometheusRuleArgs
 *             {
 *                 Expression = "histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\"billing-processing\"}[5m])) by (job_type))",
 *                 Labels =
 *                 {
 *                     { "team", "prod" },
 *                 },
 *                 Record = "job_type:billing_jobs_duration_seconds:99p5m",
 *             },
 *             new AzureNative.AlertsManagement.Inputs.PrometheusRuleArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     new AzureNative.AlertsManagement.Inputs.PrometheusRuleGroupActionArgs
 *                     {
 *                         ActionGroupId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myactiongroup",
 *                         ActionProperties =
 *                         {
 *                             { "key11", "value11" },
 *                             { "key12", "value12" },
 *                         },
 *                     },
 *                     new AzureNative.AlertsManagement.Inputs.PrometheusRuleGroupActionArgs
 *                     {
 *                         ActionGroupId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myotheractiongroup",
 *                         ActionProperties =
 *                         {
 *                             { "key21", "value21" },
 *                             { "key22", "value22" },
 *                         },
 *                     },
 *                 },
 *                 Alert = "Billing_Processing_Very_Slow",
 *                 Annotations =
 *                 {
 *                     { "annotationName1", "annotationValue1" },
 *                 },
 *                 Enabled = true,
 *                 Expression = "job_type:billing_jobs_duration_seconds:99p5m > 30",
 *                 For = "PT5M",
 *                 Labels =
 *                 {
 *                     { "team", "prod" },
 *                 },
 *                 ResolveConfiguration = new AzureNative.AlertsManagement.Inputs.PrometheusRuleResolveConfigurationArgs
 *                 {
 *                     AutoResolved = true,
 *                     TimeToResolve = "PT10M",
 *                 },
 *                 Severity = 2,
 *             },
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewPrometheusRuleGroup(ctx, "prometheusRuleGroup", &alertsmanagement.PrometheusRuleGroupArgs{
 * 			ClusterName:       pulumi.String("myClusterName"),
 * 			Description:       pulumi.String("This is the description of the following rule group"),
 * 			Enabled:           pulumi.Bool(true),
 * 			Interval:          pulumi.String("PT10M"),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("promResourceGroup"),
 * 			RuleGroupName:     pulumi.String("myPrometheusRuleGroup"),
 * 			Rules: alertsmanagement.PrometheusRuleArray{
 * 				&alertsmanagement.PrometheusRuleArgs{
 * 					Expression: pulumi.String("histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\"billing-processing\"}[5m])) by (job_type))"),
 * 					Labels: pulumi.StringMap{
 * 						"team": pulumi.String("prod"),
 * 					},
 * 					Record: pulumi.String("job_type:billing_jobs_duration_seconds:99p5m"),
 * 				},
 * 				&alertsmanagement.PrometheusRuleArgs{
 * 					Actions: alertsmanagement.PrometheusRuleGroupActionArray{
 * 						&alertsmanagement.PrometheusRuleGroupActionArgs{
 * 							ActionGroupId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myactiongroup"),
 * 							ActionProperties: pulumi.StringMap{
 * 								"key11": pulumi.String("value11"),
 * 								"key12": pulumi.String("value12"),
 * 							},
 * 						},
 * 						&alertsmanagement.PrometheusRuleGroupActionArgs{
 * 							ActionGroupId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myotheractiongroup"),
 * 							ActionProperties: pulumi.StringMap{
 * 								"key21": pulumi.String("value21"),
 * 								"key22": pulumi.String("value22"),
 * 							},
 * 						},
 * 					},
 * 					Alert: pulumi.String("Billing_Processing_Very_Slow"),
 * 					Annotations: pulumi.StringMap{
 * 						"annotationName1": pulumi.String("annotationValue1"),
 * 					},
 * 					Enabled:    pulumi.Bool(true),
 * 					Expression: pulumi.String("job_type:billing_jobs_duration_seconds:99p5m > 30"),
 * 					For:        pulumi.String("PT5M"),
 * 					Labels: pulumi.StringMap{
 * 						"team": pulumi.String("prod"),
 * 					},
 * 					ResolveConfiguration: &alertsmanagement.PrometheusRuleResolveConfigurationArgs{
 * 						AutoResolved:  pulumi.Bool(true),
 * 						TimeToResolve: pulumi.String("PT10M"),
 * 					},
 * 					Severity: pulumi.Int(2),
 * 				},
 * 			},
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroup;
 * import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroupArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleResolveConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prometheusRuleGroup = new PrometheusRuleGroup("prometheusRuleGroup", PrometheusRuleGroupArgs.builder()
 *             .clusterName("myClusterName")
 *             .description("This is the description of the following rule group")
 *             .enabled(true)
 *             .interval("PT10M")
 *             .location("East US")
 *             .resourceGroupName("promResourceGroup")
 *             .ruleGroupName("myPrometheusRuleGroup")
 *             .rules(
 *                 PrometheusRuleArgs.builder()
 *                     .expression("histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\"billing-processing\"}[5m])) by (job_type))")
 *                     .labels(Map.of("team", "prod"))
 *                     .record("job_type:billing_jobs_duration_seconds:99p5m")
 *                     .build(),
 *                 PrometheusRuleArgs.builder()
 *                     .actions(
 *                         PrometheusRuleGroupActionArgs.builder()
 *                             .actionGroupId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myactiongroup")
 *                             .actionProperties(Map.ofEntries(
 *                                 Map.entry("key11", "value11"),
 *                                 Map.entry("key12", "value12")
 *                             ))
 *                             .build(),
 *                         PrometheusRuleGroupActionArgs.builder()
 *                             .actionGroupId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myotheractiongroup")
 *                             .actionProperties(Map.ofEntries(
 *                                 Map.entry("key21", "value21"),
 *                                 Map.entry("key22", "value22")
 *                             ))
 *                             .build())
 *                     .alert("Billing_Processing_Very_Slow")
 *                     .annotations(Map.of("annotationName1", "annotationValue1"))
 *                     .enabled(true)
 *                     .expression("job_type:billing_jobs_duration_seconds:99p5m > 30")
 *                     .for_("PT5M")
 *                     .labels(Map.of("team", "prod"))
 *                     .resolveConfiguration(PrometheusRuleResolveConfigurationArgs.builder()
 *                         .autoResolved(true)
 *                         .timeToResolve("PT10M")
 *                         .build())
 *                     .severity(2)
 *                     .build())
 *             .scopes("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a cluster centric PrometheusRuleGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prometheusRuleGroup = new AzureNative.AlertsManagement.PrometheusRuleGroup("prometheusRuleGroup", new()
 *     {
 *         ClusterName = "myClusterName",
 *         Description = "This is a rule group with culster centric configuration",
 *         Interval = "PT10M",
 *         Location = "East US",
 *         ResourceGroupName = "promResourceGroup",
 *         RuleGroupName = "myPrometheusRuleGroup",
 *         Rules = new[]
 *         {
 *             new AzureNative.AlertsManagement.Inputs.PrometheusRuleArgs
 *             {
 *                 Actions = new() { },
 *                 Alert = "Billing_Processing_Very_Slow",
 *                 Annotations =
 *                 {
 *                     { "annotationName1", "annotationValue1" },
 *                 },
 *                 Enabled = true,
 *                 Expression = "job_type:billing_jobs_duration_seconds:99p5m > 30",
 *                 For = "PT5M",
 *                 Labels =
 *                 {
 *                     { "team", "prod" },
 *                 },
 *                 ResolveConfiguration = new AzureNative.AlertsManagement.Inputs.PrometheusRuleResolveConfigurationArgs
 *                 {
 *                     AutoResolved = true,
 *                     TimeToResolve = "PT10M",
 *                 },
 *                 Severity = 2,
 *             },
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace",
 *             "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myClusterName",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewPrometheusRuleGroup(ctx, "prometheusRuleGroup", &alertsmanagement.PrometheusRuleGroupArgs{
 * 			ClusterName:       pulumi.String("myClusterName"),
 * 			Description:       pulumi.String("This is a rule group with culster centric configuration"),
 * 			Interval:          pulumi.String("PT10M"),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("promResourceGroup"),
 * 			RuleGroupName:     pulumi.String("myPrometheusRuleGroup"),
 * 			Rules: alertsmanagement.PrometheusRuleArray{
 * 				&alertsmanagement.PrometheusRuleArgs{
 * 					Actions: alertsmanagement.PrometheusRuleGroupActionArray{},
 * 					Alert:   pulumi.String("Billing_Processing_Very_Slow"),
 * 					Annotations: pulumi.StringMap{
 * 						"annotationName1": pulumi.String("annotationValue1"),
 * 					},
 * 					Enabled:    pulumi.Bool(true),
 * 					Expression: pulumi.String("job_type:billing_jobs_duration_seconds:99p5m > 30"),
 * 					For:        pulumi.String("PT5M"),
 * 					Labels: pulumi.StringMap{
 * 						"team": pulumi.String("prod"),
 * 					},
 * 					ResolveConfiguration: &alertsmanagement.PrometheusRuleResolveConfigurationArgs{
 * 						AutoResolved:  pulumi.Bool(true),
 * 						TimeToResolve: pulumi.String("PT10M"),
 * 					},
 * 					Severity: pulumi.Int(2),
 * 				},
 * 			},
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
 * 				pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myClusterName"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroup;
 * import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroupArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleResolveConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prometheusRuleGroup = new PrometheusRuleGroup("prometheusRuleGroup", PrometheusRuleGroupArgs.builder()
 *             .clusterName("myClusterName")
 *             .description("This is a rule group with culster centric configuration")
 *             .interval("PT10M")
 *             .location("East US")
 *             .resourceGroupName("promResourceGroup")
 *             .ruleGroupName("myPrometheusRuleGroup")
 *             .rules(PrometheusRuleArgs.builder()
 *                 .actions()
 *                 .alert("Billing_Processing_Very_Slow")
 *                 .annotations(Map.of("annotationName1", "annotationValue1"))
 *                 .enabled(true)
 *                 .expression("job_type:billing_jobs_duration_seconds:99p5m > 30")
 *                 .for_("PT5M")
 *                 .labels(Map.of("team", "prod"))
 *                 .resolveConfiguration(PrometheusRuleResolveConfigurationArgs.builder()
 *                     .autoResolved(true)
 *                     .timeToResolve("PT10M")
 *                     .build())
 *                 .severity(2)
 *                 .build())
 *             .scopes(
 *                 "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace",
 *                 "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myClusterName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:alertsmanagement:PrometheusRuleGroup myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/prometheusRuleGroups/{ruleGroupName}
 * ```
 */
public class PrometheusRuleGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroup,
) : KotlinCustomResource(javaResource, PrometheusRuleGroupMapper) {
    /**
     * Apply rule to data from a specific cluster.
     */
    public val clusterName: Output<String>?
        get() = javaResource.clusterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Rule group description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable/disable rule group.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The interval in which to run the Prometheus rule group represented in ISO 8601 duration format. Should be between 1 and 15 minutes
     */
    public val interval: Output<String>?
        get() = javaResource.interval().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the rules in the Prometheus rule group.
     */
    public val rules: Output<List<PrometheusRuleResponse>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    prometheusRuleResponseToKotlin(args0)
                })
            })
        })

    /**
     * Target Azure Monitor workspaces resource ids. This api-version is currently limited to creating with one scope. This may change in future.
     */
    public val scopes: Output<List<String>>
        get() = javaResource.scopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrometheusRuleGroupMapper : ResourceMapper<PrometheusRuleGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroup::class == javaResource::class

    override fun map(javaResource: Resource): PrometheusRuleGroup = PrometheusRuleGroup(
        javaResource
            as com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroup,
    )
}

/**
 * @see [PrometheusRuleGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrometheusRuleGroup].
 */
public suspend fun prometheusRuleGroup(
    name: String,
    block: suspend PrometheusRuleGroupResourceBuilder.() -> Unit,
): PrometheusRuleGroup {
    val builder = PrometheusRuleGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrometheusRuleGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun prometheusRuleGroup(name: String): PrometheusRuleGroup {
    val builder = PrometheusRuleGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
