@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin

import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroupArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.PrometheusRuleArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.PrometheusRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Prometheus rule group resource.
 * Azure REST API version: 2023-03-01.
 * ## Example Usage
 * ### Create or Update a PrometheusRuleGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prometheusRuleGroup = new AzureNative.AlertsManagement.PrometheusRuleGroup("prometheusRuleGroup", new()
 *     {
 *         ClusterName = "myClusterName",
 *         Description = "This is the description of the following rule group",
 *         Enabled = true,
 *         Interval = "PT10M",
 *         Location = "East US",
 *         ResourceGroupName = "promResourceGroup",
 *         RuleGroupName = "myPrometheusRuleGroup",
 *         Rules = new[]
 *         {
 *             new AzureNative.AlertsManagement.Inputs.PrometheusRuleArgs
 *             {
 *                 Expression = "histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\"billing-processing\"}[5m])) by (job_type))",
 *                 Labels =
 *                 {
 *                     { "team", "prod" },
 *                 },
 *                 Record = "job_type:billing_jobs_duration_seconds:99p5m",
 *             },
 *             new AzureNative.AlertsManagement.Inputs.PrometheusRuleArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     new AzureNative.AlertsManagement.Inputs.PrometheusRuleGroupActionArgs
 *                     {
 *                         ActionGroupId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myactiongroup",
 *                         ActionProperties =
 *                         {
 *                             { "key11", "value11" },
 *                             { "key12", "value12" },
 *                         },
 *                     },
 *                     new AzureNative.AlertsManagement.Inputs.PrometheusRuleGroupActionArgs
 *                     {
 *                         ActionGroupId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myotheractiongroup",
 *                         ActionProperties =
 *                         {
 *                             { "key21", "value21" },
 *                             { "key22", "value22" },
 *                         },
 *                     },
 *                 },
 *                 Alert = "Billing_Processing_Very_Slow",
 *                 Annotations =
 *                 {
 *                     { "annotationName1", "annotationValue1" },
 *                 },
 *                 Enabled = true,
 *                 Expression = "job_type:billing_jobs_duration_seconds:99p5m > 30",
 *                 For = "PT5M",
 *                 Labels =
 *                 {
 *                     { "team", "prod" },
 *                 },
 *                 ResolveConfiguration = new AzureNative.AlertsManagement.Inputs.PrometheusRuleResolveConfigurationArgs
 *                 {
 *                     AutoResolved = true,
 *                     TimeToResolve = "PT10M",
 *                 },
 *                 Severity = 2,
 *             },
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewPrometheusRuleGroup(ctx, "prometheusRuleGroup", &alertsmanagement.PrometheusRuleGroupArgs{
 * 			ClusterName:       pulumi.String("myClusterName"),
 * 			Description:       pulumi.String("This is the description of the following rule group"),
 * 			Enabled:           pulumi.Bool(true),
 * 			Interval:          pulumi.String("PT10M"),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("promResourceGroup"),
 * 			RuleGroupName:     pulumi.String("myPrometheusRuleGroup"),
 * 			Rules: alertsmanagement.PrometheusRuleArray{
 * 				&alertsmanagement.PrometheusRuleArgs{
 * 					Expression: pulumi.String("histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\"billing-processing\"}[5m])) by (job_type))"),
 * 					Labels: pulumi.StringMap{
 * 						"team": pulumi.String("prod"),
 * 					},
 * 					Record: pulumi.String("job_type:billing_jobs_duration_seconds:99p5m"),
 * 				},
 * 				&alertsmanagement.PrometheusRuleArgs{
 * 					Actions: alertsmanagement.PrometheusRuleGroupActionArray{
 * 						&alertsmanagement.PrometheusRuleGroupActionArgs{
 * 							ActionGroupId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myactiongroup"),
 * 							ActionProperties: pulumi.StringMap{
 * 								"key11": pulumi.String("value11"),
 * 								"key12": pulumi.String("value12"),
 * 							},
 * 						},
 * 						&alertsmanagement.PrometheusRuleGroupActionArgs{
 * 							ActionGroupId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myotheractiongroup"),
 * 							ActionProperties: pulumi.StringMap{
 * 								"key21": pulumi.String("value21"),
 * 								"key22": pulumi.String("value22"),
 * 							},
 * 						},
 * 					},
 * 					Alert: pulumi.String("Billing_Processing_Very_Slow"),
 * 					Annotations: pulumi.StringMap{
 * 						"annotationName1": pulumi.String("annotationValue1"),
 * 					},
 * 					Enabled:    pulumi.Bool(true),
 * 					Expression: pulumi.String("job_type:billing_jobs_duration_seconds:99p5m > 30"),
 * 					For:        pulumi.String("PT5M"),
 * 					Labels: pulumi.StringMap{
 * 						"team": pulumi.String("prod"),
 * 					},
 * 					ResolveConfiguration: &alertsmanagement.PrometheusRuleResolveConfigurationArgs{
 * 						AutoResolved:  pulumi.Bool(true),
 * 						TimeToResolve: pulumi.String("PT10M"),
 * 					},
 * 					Severity: pulumi.Int(2),
 * 				},
 * 			},
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroup;
 * import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroupArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleResolveConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prometheusRuleGroup = new PrometheusRuleGroup("prometheusRuleGroup", PrometheusRuleGroupArgs.builder()
 *             .clusterName("myClusterName")
 *             .description("This is the description of the following rule group")
 *             .enabled(true)
 *             .interval("PT10M")
 *             .location("East US")
 *             .resourceGroupName("promResourceGroup")
 *             .ruleGroupName("myPrometheusRuleGroup")
 *             .rules(
 *                 PrometheusRuleArgs.builder()
 *                     .expression("histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\"billing-processing\"}[5m])) by (job_type))")
 *                     .labels(Map.of("team", "prod"))
 *                     .record("job_type:billing_jobs_duration_seconds:99p5m")
 *                     .build(),
 *                 PrometheusRuleArgs.builder()
 *                     .actions(
 *                         PrometheusRuleGroupActionArgs.builder()
 *                             .actionGroupId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myactiongroup")
 *                             .actionProperties(Map.ofEntries(
 *                                 Map.entry("key11", "value11"),
 *                                 Map.entry("key12", "value12")
 *                             ))
 *                             .build(),
 *                         PrometheusRuleGroupActionArgs.builder()
 *                             .actionGroupId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/myrg/providers/microsoft.insights/actiongroups/myotheractiongroup")
 *                             .actionProperties(Map.ofEntries(
 *                                 Map.entry("key21", "value21"),
 *                                 Map.entry("key22", "value22")
 *                             ))
 *                             .build())
 *                     .alert("Billing_Processing_Very_Slow")
 *                     .annotations(Map.of("annotationName1", "annotationValue1"))
 *                     .enabled(true)
 *                     .expression("job_type:billing_jobs_duration_seconds:99p5m > 30")
 *                     .for_("PT5M")
 *                     .labels(Map.of("team", "prod"))
 *                     .resolveConfiguration(PrometheusRuleResolveConfigurationArgs.builder()
 *                         .autoResolved(true)
 *                         .timeToResolve("PT10M")
 *                         .build())
 *                     .severity(2)
 *                     .build())
 *             .scopes("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update a cluster centric PrometheusRuleGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prometheusRuleGroup = new AzureNative.AlertsManagement.PrometheusRuleGroup("prometheusRuleGroup", new()
 *     {
 *         ClusterName = "myClusterName",
 *         Description = "This is a rule group with culster centric configuration",
 *         Interval = "PT10M",
 *         Location = "East US",
 *         ResourceGroupName = "promResourceGroup",
 *         RuleGroupName = "myPrometheusRuleGroup",
 *         Rules = new[]
 *         {
 *             new AzureNative.AlertsManagement.Inputs.PrometheusRuleArgs
 *             {
 *                 Actions = new() { },
 *                 Alert = "Billing_Processing_Very_Slow",
 *                 Annotations =
 *                 {
 *                     { "annotationName1", "annotationValue1" },
 *                 },
 *                 Enabled = true,
 *                 Expression = "job_type:billing_jobs_duration_seconds:99p5m > 30",
 *                 For = "PT5M",
 *                 Labels =
 *                 {
 *                     { "team", "prod" },
 *                 },
 *                 ResolveConfiguration = new AzureNative.AlertsManagement.Inputs.PrometheusRuleResolveConfigurationArgs
 *                 {
 *                     AutoResolved = true,
 *                     TimeToResolve = "PT10M",
 *                 },
 *                 Severity = 2,
 *             },
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace",
 *             "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myClusterName",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewPrometheusRuleGroup(ctx, "prometheusRuleGroup", &alertsmanagement.PrometheusRuleGroupArgs{
 * 			ClusterName:       pulumi.String("myClusterName"),
 * 			Description:       pulumi.String("This is a rule group with culster centric configuration"),
 * 			Interval:          pulumi.String("PT10M"),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("promResourceGroup"),
 * 			RuleGroupName:     pulumi.String("myPrometheusRuleGroup"),
 * 			Rules: alertsmanagement.PrometheusRuleArray{
 * 				&alertsmanagement.PrometheusRuleArgs{
 * 					Actions: alertsmanagement.PrometheusRuleGroupActionArray{},
 * 					Alert:   pulumi.String("Billing_Processing_Very_Slow"),
 * 					Annotations: pulumi.StringMap{
 * 						"annotationName1": pulumi.String("annotationValue1"),
 * 					},
 * 					Enabled:    pulumi.Bool(true),
 * 					Expression: pulumi.String("job_type:billing_jobs_duration_seconds:99p5m > 30"),
 * 					For:        pulumi.String("PT5M"),
 * 					Labels: pulumi.StringMap{
 * 						"team": pulumi.String("prod"),
 * 					},
 * 					ResolveConfiguration: &alertsmanagement.PrometheusRuleResolveConfigurationArgs{
 * 						AutoResolved:  pulumi.Bool(true),
 * 						TimeToResolve: pulumi.String("PT10M"),
 * 					},
 * 					Severity: pulumi.Int(2),
 * 				},
 * 			},
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
 * 				pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myClusterName"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroup;
 * import com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroupArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleArgs;
 * import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleResolveConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prometheusRuleGroup = new PrometheusRuleGroup("prometheusRuleGroup", PrometheusRuleGroupArgs.builder()
 *             .clusterName("myClusterName")
 *             .description("This is a rule group with culster centric configuration")
 *             .interval("PT10M")
 *             .location("East US")
 *             .resourceGroupName("promResourceGroup")
 *             .ruleGroupName("myPrometheusRuleGroup")
 *             .rules(PrometheusRuleArgs.builder()
 *                 .actions()
 *                 .alert("Billing_Processing_Very_Slow")
 *                 .annotations(Map.of("annotationName1", "annotationValue1"))
 *                 .enabled(true)
 *                 .expression("job_type:billing_jobs_duration_seconds:99p5m > 30")
 *                 .for_("PT5M")
 *                 .labels(Map.of("team", "prod"))
 *                 .resolveConfiguration(PrometheusRuleResolveConfigurationArgs.builder()
 *                     .autoResolved(true)
 *                     .timeToResolve("PT10M")
 *                     .build())
 *                 .severity(2)
 *                 .build())
 *             .scopes(
 *                 "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace",
 *                 "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myClusterName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:alertsmanagement:PrometheusRuleGroup myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/prometheusRuleGroups/{ruleGroupName}
 * ```
 * @property clusterName Apply rule to data from a specific cluster.
 * @property description Rule group description.
 * @property enabled Enable/disable rule group.
 * @property interval The interval in which to run the Prometheus rule group represented in ISO 8601 duration format. Should be between 1 and 15 minutes
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleGroupName The name of the rule group.
 * @property rules Defines the rules in the Prometheus rule group.
 * @property scopes Target Azure Monitor workspaces resource ids. This api-version is currently limited to creating with one scope. This may change in future.
 * @property tags Resource tags.
 */
public data class PrometheusRuleGroupArgs(
    public val clusterName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val interval: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleGroupName: Output<String>? = null,
    public val rules: Output<List<PrometheusRuleArgs>>? = null,
    public val scopes: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroupArgs =
        com.pulumi.azurenative.alertsmanagement.PrometheusRuleGroupArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleGroupName(ruleGroupName?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrometheusRuleGroupArgs].
 */
@PulumiTagMarker
public class PrometheusRuleGroupArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var interval: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleGroupName: Output<String>? = null

    private var rules: Output<List<PrometheusRuleArgs>>? = null

    private var scopes: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Apply rule to data from a specific cluster.
     */
    @JvmName("xjqjpmjuwwygcrsw")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Rule group description.
     */
    @JvmName("ysdfhdgkesblfxjb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Enable/disable rule group.
     */
    @JvmName("slyrcyaoveigkudp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The interval in which to run the Prometheus rule group represented in ISO 8601 duration format. Should be between 1 and 15 minutes
     */
    @JvmName("yudvqtkupxmllqmt")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jxxayrerdqbmqqka")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mqafxospbsweyjpa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the rule group.
     */
    @JvmName("xbruhmshnxbjqbgd")
    public suspend fun ruleGroupName(`value`: Output<String>) {
        this.ruleGroupName = value
    }

    /**
     * @param value Defines the rules in the Prometheus rule group.
     */
    @JvmName("ldyaefsanbuvhlps")
    public suspend fun rules(`value`: Output<List<PrometheusRuleArgs>>) {
        this.rules = value
    }

    @JvmName("mkdgwqccmxlpmyph")
    public suspend fun rules(vararg values: Output<PrometheusRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Defines the rules in the Prometheus rule group.
     */
    @JvmName("tsixuxivoeclgkbm")
    public suspend fun rules(values: List<Output<PrometheusRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Target Azure Monitor workspaces resource ids. This api-version is currently limited to creating with one scope. This may change in future.
     */
    @JvmName("wkwyydslycrqiweb")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("ekamclehbwogylcf")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values Target Azure Monitor workspaces resource ids. This api-version is currently limited to creating with one scope. This may change in future.
     */
    @JvmName("usvxepkkihiqfqbo")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wobnwxtbjnxjtbjd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Apply rule to data from a specific cluster.
     */
    @JvmName("whtiliquhicwgtdd")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Rule group description.
     */
    @JvmName("tdikpiufptrsydqx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Enable/disable rule group.
     */
    @JvmName("nfltnpeihomawmqi")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The interval in which to run the Prometheus rule group represented in ISO 8601 duration format. Should be between 1 and 15 minutes
     */
    @JvmName("gjfxjrlvpumcxiyv")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("phnscixkkkwxodan")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("opmwvlmwrrjlvwxy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the rule group.
     */
    @JvmName("dbcnuaqckfffetux")
    public suspend fun ruleGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleGroupName = mapped
    }

    /**
     * @param value Defines the rules in the Prometheus rule group.
     */
    @JvmName("uafxhdndplhrpxqk")
    public suspend fun rules(`value`: List<PrometheusRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Defines the rules in the Prometheus rule group.
     */
    @JvmName("tcvrvcvgrfjkfxlf")
    public suspend fun rules(argument: List<suspend PrometheusRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrometheusRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Defines the rules in the Prometheus rule group.
     */
    @JvmName("nkvkcuocaudcqcvs")
    public suspend fun rules(vararg argument: suspend PrometheusRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrometheusRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Defines the rules in the Prometheus rule group.
     */
    @JvmName("yoxtwmdkuyhulooe")
    public suspend fun rules(argument: suspend PrometheusRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrometheusRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Defines the rules in the Prometheus rule group.
     */
    @JvmName("dxgsurujojbimlfh")
    public suspend fun rules(vararg values: PrometheusRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Target Azure Monitor workspaces resource ids. This api-version is currently limited to creating with one scope. This may change in future.
     */
    @JvmName("uqhlggmlhppwahvo")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values Target Azure Monitor workspaces resource ids. This api-version is currently limited to creating with one scope. This may change in future.
     */
    @JvmName("esdinbimcwbhteql")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fpjoluipuihitgot")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("giphmsasgykxesua")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrometheusRuleGroupArgs = PrometheusRuleGroupArgs(
        clusterName = clusterName,
        description = description,
        enabled = enabled,
        interval = interval,
        location = location,
        resourceGroupName = resourceGroupName,
        ruleGroupName = ruleGroupName,
        rules = rules,
        scopes = scopes,
        tags = tags,
    )
}
