@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupsInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Action Groups information, used by the alert rule.
 * @property customEmailSubject An optional custom email subject to use in email notifications.
 * @property customWebhookPayload An optional custom web-hook payload to use in web-hook notifications.
 * @property groupIds The Action Group resource IDs.
 */
public data class ActionGroupsInformationArgs(
    public val customEmailSubject: Output<String>? = null,
    public val customWebhookPayload: Output<String>? = null,
    public val groupIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupsInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupsInformationArgs = com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupsInformationArgs.builder()
        .customEmailSubject(customEmailSubject?.applyValue({ args0 -> args0 }))
        .customWebhookPayload(customWebhookPayload?.applyValue({ args0 -> args0 }))
        .groupIds(groupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ActionGroupsInformationArgs].
 */
@PulumiTagMarker
public class ActionGroupsInformationArgsBuilder internal constructor() {
    private var customEmailSubject: Output<String>? = null

    private var customWebhookPayload: Output<String>? = null

    private var groupIds: Output<List<String>>? = null

    /**
     * @param value An optional custom email subject to use in email notifications.
     */
    @JvmName("xstmyslkskgujkql")
    public suspend fun customEmailSubject(`value`: Output<String>) {
        this.customEmailSubject = value
    }

    /**
     * @param value An optional custom web-hook payload to use in web-hook notifications.
     */
    @JvmName("nretlxmxhajeypda")
    public suspend fun customWebhookPayload(`value`: Output<String>) {
        this.customWebhookPayload = value
    }

    /**
     * @param value The Action Group resource IDs.
     */
    @JvmName("doxrqjdddebbfvkb")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("vvekeearjrkeegvw")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The Action Group resource IDs.
     */
    @JvmName("thkxiqiupwijoktu")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value An optional custom email subject to use in email notifications.
     */
    @JvmName("xvgcymxkpkinclxj")
    public suspend fun customEmailSubject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEmailSubject = mapped
    }

    /**
     * @param value An optional custom web-hook payload to use in web-hook notifications.
     */
    @JvmName("viutyngfjehdtiij")
    public suspend fun customWebhookPayload(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customWebhookPayload = mapped
    }

    /**
     * @param value The Action Group resource IDs.
     */
    @JvmName("ixkgpmkmmmxlaeju")
    public suspend fun groupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The Action Group resource IDs.
     */
    @JvmName("gmddodcuhhlmskyb")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    internal fun build(): ActionGroupsInformationArgs = ActionGroupsInformationArgs(
        customEmailSubject = customEmailSubject,
        customWebhookPayload = customWebhookPayload,
        groupIds = groupIds ?: throw PulumiNullFieldException("groupIds"),
    )
}
