@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.ConditionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Conditions in alert instance to be matched for a given action rule. Default value is all. Multiple values could be provided with comma separation.
 * @property alertContext filter alerts by alert context (payload)
 * @property alertRuleId filter alerts by alert rule id
 * @property alertRuleName filter alerts by alert rule name
 * @property description filter alerts by alert rule description
 * @property monitorCondition filter alerts by monitor condition
 * @property monitorService filter alerts by monitor service
 * @property severity filter alerts by severity
 * @property targetResourceType filter alerts by target resource type
 */
public data class ConditionsArgs(
    public val alertContext: Output<ConditionArgs>? = null,
    public val alertRuleId: Output<ConditionArgs>? = null,
    public val alertRuleName: Output<ConditionArgs>? = null,
    public val description: Output<ConditionArgs>? = null,
    public val monitorCondition: Output<ConditionArgs>? = null,
    public val monitorService: Output<ConditionArgs>? = null,
    public val severity: Output<ConditionArgs>? = null,
    public val targetResourceType: Output<ConditionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.ConditionsArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.ConditionsArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.ConditionsArgs.builder()
            .alertContext(alertContext?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .alertRuleId(alertRuleId?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .alertRuleName(alertRuleName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitorCondition(monitorCondition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitorService(monitorService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .severity(severity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetResourceType(
                targetResourceType?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConditionsArgs].
 */
@PulumiTagMarker
public class ConditionsArgsBuilder internal constructor() {
    private var alertContext: Output<ConditionArgs>? = null

    private var alertRuleId: Output<ConditionArgs>? = null

    private var alertRuleName: Output<ConditionArgs>? = null

    private var description: Output<ConditionArgs>? = null

    private var monitorCondition: Output<ConditionArgs>? = null

    private var monitorService: Output<ConditionArgs>? = null

    private var severity: Output<ConditionArgs>? = null

    private var targetResourceType: Output<ConditionArgs>? = null

    /**
     * @param value filter alerts by alert context (payload)
     */
    @JvmName("rsapjvgfucuiijsq")
    public suspend fun alertContext(`value`: Output<ConditionArgs>) {
        this.alertContext = value
    }

    /**
     * @param value filter alerts by alert rule id
     */
    @JvmName("hjggrehvalihgmdo")
    public suspend fun alertRuleId(`value`: Output<ConditionArgs>) {
        this.alertRuleId = value
    }

    /**
     * @param value filter alerts by alert rule name
     */
    @JvmName("dmaehpikxpwnaquy")
    public suspend fun alertRuleName(`value`: Output<ConditionArgs>) {
        this.alertRuleName = value
    }

    /**
     * @param value filter alerts by alert rule description
     */
    @JvmName("vwfokxgriknbpsqs")
    public suspend fun description(`value`: Output<ConditionArgs>) {
        this.description = value
    }

    /**
     * @param value filter alerts by monitor condition
     */
    @JvmName("tuhmpolunhtegskt")
    public suspend fun monitorCondition(`value`: Output<ConditionArgs>) {
        this.monitorCondition = value
    }

    /**
     * @param value filter alerts by monitor service
     */
    @JvmName("muclylawksoivovg")
    public suspend fun monitorService(`value`: Output<ConditionArgs>) {
        this.monitorService = value
    }

    /**
     * @param value filter alerts by severity
     */
    @JvmName("lskboyqmxjrqsnfy")
    public suspend fun severity(`value`: Output<ConditionArgs>) {
        this.severity = value
    }

    /**
     * @param value filter alerts by target resource type
     */
    @JvmName("tdgjdodcpyurcrxl")
    public suspend fun targetResourceType(`value`: Output<ConditionArgs>) {
        this.targetResourceType = value
    }

    /**
     * @param value filter alerts by alert context (payload)
     */
    @JvmName("spbchsbovqlspqoi")
    public suspend fun alertContext(`value`: ConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertContext = mapped
    }

    /**
     * @param argument filter alerts by alert context (payload)
     */
    @JvmName("nqtlwuvllyrjxolh")
    public suspend fun alertContext(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alertContext = mapped
    }

    /**
     * @param value filter alerts by alert rule id
     */
    @JvmName("ujtyxqotcfouclkb")
    public suspend fun alertRuleId(`value`: ConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertRuleId = mapped
    }

    /**
     * @param argument filter alerts by alert rule id
     */
    @JvmName("dhrcqjmhftyqcmgr")
    public suspend fun alertRuleId(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alertRuleId = mapped
    }

    /**
     * @param value filter alerts by alert rule name
     */
    @JvmName("flifoanhnaohwclm")
    public suspend fun alertRuleName(`value`: ConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertRuleName = mapped
    }

    /**
     * @param argument filter alerts by alert rule name
     */
    @JvmName("naxvumxchjfyrrdg")
    public suspend fun alertRuleName(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.alertRuleName = mapped
    }

    /**
     * @param value filter alerts by alert rule description
     */
    @JvmName("xpnucbxcwxswgrpi")
    public suspend fun description(`value`: ConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param argument filter alerts by alert rule description
     */
    @JvmName("kjxnlamoesfeichb")
    public suspend fun description(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.description = mapped
    }

    /**
     * @param value filter alerts by monitor condition
     */
    @JvmName("xwwlrqwifefgdtok")
    public suspend fun monitorCondition(`value`: ConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorCondition = mapped
    }

    /**
     * @param argument filter alerts by monitor condition
     */
    @JvmName("uuqneasninkywgkm")
    public suspend fun monitorCondition(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monitorCondition = mapped
    }

    /**
     * @param value filter alerts by monitor service
     */
    @JvmName("jlnfxfvowmrfktds")
    public suspend fun monitorService(`value`: ConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorService = mapped
    }

    /**
     * @param argument filter alerts by monitor service
     */
    @JvmName("axewqlgkuvocudec")
    public suspend fun monitorService(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monitorService = mapped
    }

    /**
     * @param value filter alerts by severity
     */
    @JvmName("kkasrkckqmbekaib")
    public suspend fun severity(`value`: ConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param argument filter alerts by severity
     */
    @JvmName("crlnggguwslqxlhu")
    public suspend fun severity(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.severity = mapped
    }

    /**
     * @param value filter alerts by target resource type
     */
    @JvmName("wcsqruevgadfqamu")
    public suspend fun targetResourceType(`value`: ConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceType = mapped
    }

    /**
     * @param argument filter alerts by target resource type
     */
    @JvmName("igxjfluxkqueptju")
    public suspend fun targetResourceType(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetResourceType = mapped
    }

    internal fun build(): ConditionsArgs = ConditionsArgs(
        alertContext = alertContext,
        alertRuleId = alertRuleId,
        alertRuleName = alertRuleName,
        description = description,
        monitorCondition = monitorCondition,
        monitorService = monitorService,
        severity = severity,
        targetResourceType = targetResourceType,
    )
}
