@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.GetAlertProcessingRuleByNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alertProcessingRuleName The name of the alert processing rule that needs to be fetched.
 * @property resourceGroupName Resource group name where the resource is created.
 */
public data class GetAlertProcessingRuleByNamePlainArgs(
    public val alertProcessingRuleName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.GetAlertProcessingRuleByNamePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.GetAlertProcessingRuleByNamePlainArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.GetAlertProcessingRuleByNamePlainArgs.builder()
            .alertProcessingRuleName(alertProcessingRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlertProcessingRuleByNamePlainArgs].
 */
@PulumiTagMarker
public class GetAlertProcessingRuleByNamePlainArgsBuilder internal constructor() {
    private var alertProcessingRuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the alert processing rule that needs to be fetched.
     */
    @JvmName("evcljmyquwcbolno")
    public suspend fun alertProcessingRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.alertProcessingRuleName = mapped
    }

    /**
     * @param value Resource group name where the resource is created.
     */
    @JvmName("lussilpghpmcvifc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAlertProcessingRuleByNamePlainArgs =
        GetAlertProcessingRuleByNamePlainArgs(
            alertProcessingRuleName = alertProcessingRuleName ?: throw
                PulumiNullFieldException("alertProcessingRuleName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
