@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.GetSmartDetectorAlertRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alertRuleName The name of the alert rule.
 * @property expandDetector Indicates if Smart Detector should be expanded.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetSmartDetectorAlertRulePlainArgs(
    public val alertRuleName: String,
    public val expandDetector: Boolean? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.GetSmartDetectorAlertRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.GetSmartDetectorAlertRulePlainArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.GetSmartDetectorAlertRulePlainArgs.builder()
            .alertRuleName(alertRuleName.let({ args0 -> args0 }))
            .expandDetector(expandDetector?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSmartDetectorAlertRulePlainArgs].
 */
@PulumiTagMarker
public class GetSmartDetectorAlertRulePlainArgsBuilder internal constructor() {
    private var alertRuleName: String? = null

    private var expandDetector: Boolean? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("nyyhbahphnbigijd")
    public suspend fun alertRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.alertRuleName = mapped
    }

    /**
     * @param value Indicates if Smart Detector should be expanded.
     */
    @JvmName("efivofwjpnutbwuv")
    public suspend fun expandDetector(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expandDetector = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bfnhdmmmjshyvglv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetSmartDetectorAlertRulePlainArgs = GetSmartDetectorAlertRulePlainArgs(
        alertRuleName = alertRuleName ?: throw PulumiNullFieldException("alertRuleName"),
        expandDetector = expandDetector,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
