@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.MonthlyRecurrenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Monthly recurrence object.
 * @property daysOfMonth Specifies the values for monthly recurrence pattern.
 * @property endTime End time for recurrence.
 * @property recurrenceType Specifies when the recurrence should be applied.
 * Expected value is 'Monthly'.
 * @property startTime Start time for recurrence.
 */
public data class MonthlyRecurrenceArgs(
    public val daysOfMonth: Output<List<Int>>,
    public val endTime: Output<String>? = null,
    public val recurrenceType: Output<String>,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.MonthlyRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.MonthlyRecurrenceArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.MonthlyRecurrenceArgs.builder()
            .daysOfMonth(daysOfMonth.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .recurrenceType(recurrenceType.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonthlyRecurrenceArgs].
 */
@PulumiTagMarker
public class MonthlyRecurrenceArgsBuilder internal constructor() {
    private var daysOfMonth: Output<List<Int>>? = null

    private var endTime: Output<String>? = null

    private var recurrenceType: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value Specifies the values for monthly recurrence pattern.
     */
    @JvmName("fltprjggriljinin")
    public suspend fun daysOfMonth(`value`: Output<List<Int>>) {
        this.daysOfMonth = value
    }

    @JvmName("kybyxsqkdmedbcqi")
    public suspend fun daysOfMonth(vararg values: Output<Int>) {
        this.daysOfMonth = Output.all(values.asList())
    }

    /**
     * @param values Specifies the values for monthly recurrence pattern.
     */
    @JvmName("ijjianiqnyfuurew")
    public suspend fun daysOfMonth(values: List<Output<Int>>) {
        this.daysOfMonth = Output.all(values)
    }

    /**
     * @param value End time for recurrence.
     */
    @JvmName("tlcugqojcnuxbpsl")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Specifies when the recurrence should be applied.
     * Expected value is 'Monthly'.
     */
    @JvmName("swfmqfxaayxnwouu")
    public suspend fun recurrenceType(`value`: Output<String>) {
        this.recurrenceType = value
    }

    /**
     * @param value Start time for recurrence.
     */
    @JvmName("uuacvbnqqopmsesr")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Specifies the values for monthly recurrence pattern.
     */
    @JvmName("twkyvkolburyoqsc")
    public suspend fun daysOfMonth(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfMonth = mapped
    }

    /**
     * @param values Specifies the values for monthly recurrence pattern.
     */
    @JvmName("xakpjnwmkidykqdn")
    public suspend fun daysOfMonth(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfMonth = mapped
    }

    /**
     * @param value End time for recurrence.
     */
    @JvmName("fjtghjpwdtogdfgw")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Specifies when the recurrence should be applied.
     * Expected value is 'Monthly'.
     */
    @JvmName("mpaawusjdiutqhmo")
    public suspend fun recurrenceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value Start time for recurrence.
     */
    @JvmName("losjojcuyadmtkhe")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): MonthlyRecurrenceArgs = MonthlyRecurrenceArgs(
        daysOfMonth = daysOfMonth ?: throw PulumiNullFieldException("daysOfMonth"),
        endTime = endTime,
        recurrenceType = recurrenceType ?: throw PulumiNullFieldException("recurrenceType"),
        startTime = startTime,
    )
}
