@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Prometheus alerting or recording rule.
 * @property actions Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
 * @property alert Alert rule name.
 * @property annotations The annotations clause specifies a set of informational labels that can be used to store longer additional information such as alert descriptions or runbook links. The annotation values can be templated.
 * @property enabled Enable/disable rule.
 * @property expression The PromQL expression to evaluate. https://prometheus.io/docs/prometheus/latest/querying/basics/. Evaluated periodically as given by 'interval', and the result recorded as a new set of time series with the metric name as given by 'record'.
 * @property for The amount of time alert must be active before firing.
 * @property labels Labels to add or overwrite before storing the result.
 * @property record Recorded metrics name.
 * @property resolveConfiguration Defines the configuration for resolving fired alerts. Only relevant for alerts.
 * @property severity The severity of the alerts fired by the rule. Must be between 0 and 4.
 */
public data class PrometheusRuleArgs(
    public val actions: Output<List<PrometheusRuleGroupActionArgs>>? = null,
    public val alert: Output<String>? = null,
    public val annotations: Output<Map<String, String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val expression: Output<String>,
    public val `for`: Output<String>? = null,
    public val labels: Output<Map<String, String>>? = null,
    public val record: Output<String>? = null,
    public val resolveConfiguration: Output<PrometheusRuleResolveConfigurationArgs>? = null,
    public val severity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .alert(alert?.applyValue({ args0 -> args0 }))
            .annotations(
                annotations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .expression(expression.applyValue({ args0 -> args0 }))
            .for_(`for`?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .record(record?.applyValue({ args0 -> args0 }))
            .resolveConfiguration(
                resolveConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .severity(severity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrometheusRuleArgs].
 */
@PulumiTagMarker
public class PrometheusRuleArgsBuilder internal constructor() {
    private var actions: Output<List<PrometheusRuleGroupActionArgs>>? = null

    private var alert: Output<String>? = null

    private var annotations: Output<Map<String, String>>? = null

    private var enabled: Output<Boolean>? = null

    private var expression: Output<String>? = null

    private var `for`: Output<String>? = null

    private var labels: Output<Map<String, String>>? = null

    private var record: Output<String>? = null

    private var resolveConfiguration: Output<PrometheusRuleResolveConfigurationArgs>? = null

    private var severity: Output<Int>? = null

    /**
     * @param value Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("jljejdtpkmfqmqfl")
    public suspend fun actions(`value`: Output<List<PrometheusRuleGroupActionArgs>>) {
        this.actions = value
    }

    @JvmName("ruygfadyiglkfrwu")
    public suspend fun actions(vararg values: Output<PrometheusRuleGroupActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("hiqhgpcjdrhfsngm")
    public suspend fun actions(values: List<Output<PrometheusRuleGroupActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Alert rule name.
     */
    @JvmName("acuiaqomvsxrnriv")
    public suspend fun alert(`value`: Output<String>) {
        this.alert = value
    }

    /**
     * @param value The annotations clause specifies a set of informational labels that can be used to store longer additional information such as alert descriptions or runbook links. The annotation values can be templated.
     */
    @JvmName("hspkgqkkyrnwriee")
    public suspend fun annotations(`value`: Output<Map<String, String>>) {
        this.annotations = value
    }

    /**
     * @param value Enable/disable rule.
     */
    @JvmName("avfebkjbfvbktfmx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The PromQL expression to evaluate. https://prometheus.io/docs/prometheus/latest/querying/basics/. Evaluated periodically as given by 'interval', and the result recorded as a new set of time series with the metric name as given by 'record'.
     */
    @JvmName("tqqbeqtwcalwdrtr")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value The amount of time alert must be active before firing.
     */
    @JvmName("ejohyxcexgatudsk")
    public suspend fun `for`(`value`: Output<String>) {
        this.`for` = value
    }

    /**
     * @param value Labels to add or overwrite before storing the result.
     */
    @JvmName("vejrcbgspiidmmdq")
    public suspend fun labels(`value`: Output<Map<String, String>>) {
        this.labels = value
    }

    /**
     * @param value Recorded metrics name.
     */
    @JvmName("tbyhdaelntagfbug")
    public suspend fun record(`value`: Output<String>) {
        this.record = value
    }

    /**
     * @param value Defines the configuration for resolving fired alerts. Only relevant for alerts.
     */
    @JvmName("igwwgvhtbdcywccm")
    public suspend fun resolveConfiguration(`value`: Output<PrometheusRuleResolveConfigurationArgs>) {
        this.resolveConfiguration = value
    }

    /**
     * @param value The severity of the alerts fired by the rule. Must be between 0 and 4.
     */
    @JvmName("kavwnsnolnrqtilp")
    public suspend fun severity(`value`: Output<Int>) {
        this.severity = value
    }

    /**
     * @param value Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("fdqhrfeckurpjhcs")
    public suspend fun actions(`value`: List<PrometheusRuleGroupActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("ntonymptbbmxdcbj")
    public suspend fun actions(argument: List<suspend PrometheusRuleGroupActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrometheusRuleGroupActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("vcklisusnhioesrs")
    public suspend fun actions(vararg argument: suspend PrometheusRuleGroupActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrometheusRuleGroupActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("rntmfjvcatwkkfqt")
    public suspend fun actions(argument: suspend PrometheusRuleGroupActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrometheusRuleGroupActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("erelrkwiuyswyswy")
    public suspend fun actions(vararg values: PrometheusRuleGroupActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Alert rule name.
     */
    @JvmName("tljbktaufddmlvlc")
    public suspend fun alert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alert = mapped
    }

    /**
     * @param value The annotations clause specifies a set of informational labels that can be used to store longer additional information such as alert descriptions or runbook links. The annotation values can be templated.
     */
    @JvmName("gnkowumapjwomfwe")
    public suspend fun annotations(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values The annotations clause specifies a set of informational labels that can be used to store longer additional information such as alert descriptions or runbook links. The annotation values can be templated.
     */
    @JvmName("oawvwgwlulbyatds")
    public fun annotations(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Enable/disable rule.
     */
    @JvmName("llleqgmsvmmqjsoc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The PromQL expression to evaluate. https://prometheus.io/docs/prometheus/latest/querying/basics/. Evaluated periodically as given by 'interval', and the result recorded as a new set of time series with the metric name as given by 'record'.
     */
    @JvmName("ndwahukfkqfjnssx")
    public suspend fun expression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value The amount of time alert must be active before firing.
     */
    @JvmName("pwmaltwmcxqduyvr")
    public suspend fun `for`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`for` = mapped
    }

    /**
     * @param value Labels to add or overwrite before storing the result.
     */
    @JvmName("wqcitqasilrlmtji")
    public suspend fun labels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values Labels to add or overwrite before storing the result.
     */
    @JvmName("ytahxnwokoihplgi")
    public fun labels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Recorded metrics name.
     */
    @JvmName("gdakjuobnnrmdhjo")
    public suspend fun record(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.record = mapped
    }

    /**
     * @param value Defines the configuration for resolving fired alerts. Only relevant for alerts.
     */
    @JvmName("okhojkhetebhlead")
    public suspend fun resolveConfiguration(`value`: PrometheusRuleResolveConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolveConfiguration = mapped
    }

    /**
     * @param argument Defines the configuration for resolving fired alerts. Only relevant for alerts.
     */
    @JvmName("bpavqihcmtndgxqw")
    public suspend fun resolveConfiguration(argument: suspend PrometheusRuleResolveConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PrometheusRuleResolveConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resolveConfiguration = mapped
    }

    /**
     * @param value The severity of the alerts fired by the rule. Must be between 0 and 4.
     */
    @JvmName("aycmjobbukkveggd")
    public suspend fun severity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    internal fun build(): PrometheusRuleArgs = PrometheusRuleArgs(
        actions = actions,
        alert = alert,
        annotations = annotations,
        enabled = enabled,
        expression = expression ?: throw PulumiNullFieldException("expression"),
        `for` = `for`,
        labels = labels,
        record = record,
        resolveConfiguration = resolveConfiguration,
        severity = severity,
    )
}
