@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleResolveConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the Prometheus alert rule configuration.
 * @property autoResolved Enable alert auto-resolution.
 * @property timeToResolve Alert auto-resolution timeout.
 */
public data class PrometheusRuleResolveConfigurationArgs(
    public val autoResolved: Output<Boolean>? = null,
    public val timeToResolve: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleResolveConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleResolveConfigurationArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.PrometheusRuleResolveConfigurationArgs.builder()
            .autoResolved(autoResolved?.applyValue({ args0 -> args0 }))
            .timeToResolve(timeToResolve?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrometheusRuleResolveConfigurationArgs].
 */
@PulumiTagMarker
public class PrometheusRuleResolveConfigurationArgsBuilder internal constructor() {
    private var autoResolved: Output<Boolean>? = null

    private var timeToResolve: Output<String>? = null

    /**
     * @param value Enable alert auto-resolution.
     */
    @JvmName("lrjrkdukiotfekbk")
    public suspend fun autoResolved(`value`: Output<Boolean>) {
        this.autoResolved = value
    }

    /**
     * @param value Alert auto-resolution timeout.
     */
    @JvmName("entayoiuucdvlync")
    public suspend fun timeToResolve(`value`: Output<String>) {
        this.timeToResolve = value
    }

    /**
     * @param value Enable alert auto-resolution.
     */
    @JvmName("lsidrvyxomwpgrgq")
    public suspend fun autoResolved(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoResolved = mapped
    }

    /**
     * @param value Alert auto-resolution timeout.
     */
    @JvmName("awdfkydctucknmgj")
    public suspend fun timeToResolve(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToResolve = mapped
    }

    internal fun build(): PrometheusRuleResolveConfigurationArgs =
        PrometheusRuleResolveConfigurationArgs(
            autoResolved = autoResolved,
            timeToResolve = timeToResolve,
        )
}
