@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.ScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Scheduling configuration for a given alert processing rule.
 * @property effectiveFrom Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix.
 * @property effectiveUntil Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix.
 * @property recurrences List of recurrences.
 * @property timeZone Scheduling time zone.
 */
public data class ScheduleArgs(
    public val effectiveFrom: Output<String>? = null,
    public val effectiveUntil: Output<String>? = null,
    public val recurrences: Output<List<Any>>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.ScheduleArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.ScheduleArgs.builder()
            .effectiveFrom(effectiveFrom?.applyValue({ args0 -> args0 }))
            .effectiveUntil(effectiveUntil?.applyValue({ args0 -> args0 }))
            .recurrences(recurrences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var effectiveFrom: Output<String>? = null

    private var effectiveUntil: Output<String>? = null

    private var recurrences: Output<List<Any>>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix.
     */
    @JvmName("ycnorqisiqosvehh")
    public suspend fun effectiveFrom(`value`: Output<String>) {
        this.effectiveFrom = value
    }

    /**
     * @param value Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix.
     */
    @JvmName("ddycvrkhgjanclge")
    public suspend fun effectiveUntil(`value`: Output<String>) {
        this.effectiveUntil = value
    }

    /**
     * @param value List of recurrences.
     */
    @JvmName("otujgougtvfvhont")
    public suspend fun recurrences(`value`: Output<List<Any>>) {
        this.recurrences = value
    }

    @JvmName("hrlnimkiaroyelyf")
    public suspend fun recurrences(vararg values: Output<Any>) {
        this.recurrences = Output.all(values.asList())
    }

    /**
     * @param values List of recurrences.
     */
    @JvmName("rtpcnydfsitkfdwt")
    public suspend fun recurrences(values: List<Output<Any>>) {
        this.recurrences = Output.all(values)
    }

    /**
     * @param value Scheduling time zone.
     */
    @JvmName("hmhsylgabkolgjes")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix.
     */
    @JvmName("wqpdargpitsiqlbj")
    public suspend fun effectiveFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveFrom = mapped
    }

    /**
     * @param value Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix.
     */
    @JvmName("oetubjppinnnlmeq")
    public suspend fun effectiveUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveUntil = mapped
    }

    /**
     * @param value List of recurrences.
     */
    @JvmName("hhuaktdjgtdsgtag")
    public suspend fun recurrences(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrences = mapped
    }

    /**
     * @param values List of recurrences.
     */
    @JvmName("shsoretwbshhxwgr")
    public suspend fun recurrences(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrences = mapped
    }

    /**
     * @param value Scheduling time zone.
     */
    @JvmName("lbskxbdrwyuaxmja")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        effectiveFrom = effectiveFrom,
        effectiveUntil = effectiveUntil,
        recurrences = recurrences,
        timeZone = timeZone,
    )
}
