@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.SuppressionArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.ActionRuleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Action rule with suppression configuration
 * @property conditions conditions on which alerts will be filtered
 * @property description Description of action rule
 * @property scope scope on which action rule will apply
 * @property status Indicates if the given action rule is enabled or disabled
 * @property suppressionConfig suppression configuration for the action rule
 * @property type Indicates type of action rule
 * Expected value is 'Suppression'.
 */
public data class SuppressionArgs(
    public val conditions: Output<ConditionsArgs>? = null,
    public val description: Output<String>? = null,
    public val scope: Output<ScopeArgs>? = null,
    public val status: Output<Either<String, ActionRuleStatus>>? = null,
    public val suppressionConfig: Output<SuppressionConfigArgs>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.SuppressionArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.SuppressionArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.SuppressionArgs.builder()
            .conditions(conditions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .suppressionConfig(suppressionConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SuppressionArgs].
 */
@PulumiTagMarker
public class SuppressionArgsBuilder internal constructor() {
    private var conditions: Output<ConditionsArgs>? = null

    private var description: Output<String>? = null

    private var scope: Output<ScopeArgs>? = null

    private var status: Output<Either<String, ActionRuleStatus>>? = null

    private var suppressionConfig: Output<SuppressionConfigArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value conditions on which alerts will be filtered
     */
    @JvmName("quahalnrdmkuxqvp")
    public suspend fun conditions(`value`: Output<ConditionsArgs>) {
        this.conditions = value
    }

    /**
     * @param value Description of action rule
     */
    @JvmName("ijtnxibyfkahkixk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value scope on which action rule will apply
     */
    @JvmName("jgphfrcrikpgqhsc")
    public suspend fun scope(`value`: Output<ScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value Indicates if the given action rule is enabled or disabled
     */
    @JvmName("dknhlkwwwpdftkfm")
    public suspend fun status(`value`: Output<Either<String, ActionRuleStatus>>) {
        this.status = value
    }

    /**
     * @param value suppression configuration for the action rule
     */
    @JvmName("binwnwxvmyknikcm")
    public suspend fun suppressionConfig(`value`: Output<SuppressionConfigArgs>) {
        this.suppressionConfig = value
    }

    /**
     * @param value Indicates type of action rule
     * Expected value is 'Suppression'.
     */
    @JvmName("mbrmtomamhewtwwg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value conditions on which alerts will be filtered
     */
    @JvmName("bsduqnrotkrrqunj")
    public suspend fun conditions(`value`: ConditionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument conditions on which alerts will be filtered
     */
    @JvmName("oqndjnhalbcrbyxw")
    public suspend fun conditions(argument: suspend ConditionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param value Description of action rule
     */
    @JvmName("vnkmqopismqfthme")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value scope on which action rule will apply
     */
    @JvmName("pbljhfhijqjtkbrn")
    public suspend fun scope(`value`: ScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument scope on which action rule will apply
     */
    @JvmName("hrokewpmkgwkfcpl")
    public suspend fun scope(argument: suspend ScopeArgsBuilder.() -> Unit) {
        val toBeMapped = ScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value Indicates if the given action rule is enabled or disabled
     */
    @JvmName("cdkparhpmeecbaek")
    public suspend fun status(`value`: Either<String, ActionRuleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates if the given action rule is enabled or disabled
     */
    @JvmName("mbeafbndxarprfqb")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionRuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates if the given action rule is enabled or disabled
     */
    @JvmName("riddrnphtvijaadq")
    public fun status(`value`: ActionRuleStatus) {
        val toBeMapped = Either.ofRight<String, ActionRuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value suppression configuration for the action rule
     */
    @JvmName("gmrongjjcmrmiwro")
    public suspend fun suppressionConfig(`value`: SuppressionConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suppressionConfig = mapped
    }

    /**
     * @param argument suppression configuration for the action rule
     */
    @JvmName("wboleyhbradphbqb")
    public suspend fun suppressionConfig(argument: suspend SuppressionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = SuppressionConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.suppressionConfig = mapped
    }

    /**
     * @param value Indicates type of action rule
     * Expected value is 'Suppression'.
     */
    @JvmName("kiruimvhpwbtvdvv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SuppressionArgs = SuppressionArgs(
        conditions = conditions,
        description = description,
        scope = scope,
        status = status,
        suppressionConfig = suppressionConfig ?: throw PulumiNullFieldException("suppressionConfig"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
