@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.WeeklyRecurrenceArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.DaysOfWeek
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Weekly recurrence object.
 * @property daysOfWeek Specifies the values for weekly recurrence pattern.
 * @property endTime End time for recurrence.
 * @property recurrenceType Specifies when the recurrence should be applied.
 * Expected value is 'Weekly'.
 * @property startTime Start time for recurrence.
 */
public data class WeeklyRecurrenceArgs(
    public val daysOfWeek: Output<List<Either<String, DaysOfWeek>>>,
    public val endTime: Output<String>? = null,
    public val recurrenceType: Output<String>,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.WeeklyRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.WeeklyRecurrenceArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.WeeklyRecurrenceArgs.builder()
            .daysOfWeek(
                daysOfWeek.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .recurrenceType(recurrenceType.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WeeklyRecurrenceArgs].
 */
@PulumiTagMarker
public class WeeklyRecurrenceArgsBuilder internal constructor() {
    private var daysOfWeek: Output<List<Either<String, DaysOfWeek>>>? = null

    private var endTime: Output<String>? = null

    private var recurrenceType: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value Specifies the values for weekly recurrence pattern.
     */
    @JvmName("wbehsbnvhsabmbyq")
    public suspend fun daysOfWeek(`value`: Output<List<Either<String, DaysOfWeek>>>) {
        this.daysOfWeek = value
    }

    @JvmName("xifsuhfquwyrxcds")
    public suspend fun daysOfWeek(vararg values: Output<Either<String, DaysOfWeek>>) {
        this.daysOfWeek = Output.all(values.asList())
    }

    /**
     * @param values Specifies the values for weekly recurrence pattern.
     */
    @JvmName("tfjiicyvmemxymid")
    public suspend fun daysOfWeek(values: List<Output<Either<String, DaysOfWeek>>>) {
        this.daysOfWeek = Output.all(values)
    }

    /**
     * @param value End time for recurrence.
     */
    @JvmName("vcdtvtyyydyvwubr")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Specifies when the recurrence should be applied.
     * Expected value is 'Weekly'.
     */
    @JvmName("xqmmpotjceyjfrsu")
    public suspend fun recurrenceType(`value`: Output<String>) {
        this.recurrenceType = value
    }

    /**
     * @param value Start time for recurrence.
     */
    @JvmName("eoidrgqftqrjnwcb")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Specifies the values for weekly recurrence pattern.
     */
    @JvmName("xfqulbkeqaatnaqv")
    public suspend fun daysOfWeek(`value`: List<Either<String, DaysOfWeek>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param values Specifies the values for weekly recurrence pattern.
     */
    @JvmName("grybmieliivfjixm")
    public suspend fun daysOfWeek(vararg values: Either<String, DaysOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param value End time for recurrence.
     */
    @JvmName("qqcdmsqwloyduhtn")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Specifies when the recurrence should be applied.
     * Expected value is 'Weekly'.
     */
    @JvmName("ymlfgedcaitpkbih")
    public suspend fun recurrenceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value Start time for recurrence.
     */
    @JvmName("dsggwuldrsmrqdnk")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): WeeklyRecurrenceArgs = WeeklyRecurrenceArgs(
        daysOfWeek = daysOfWeek ?: throw PulumiNullFieldException("daysOfWeek"),
        endTime = endTime,
        recurrenceType = recurrenceType ?: throw PulumiNullFieldException("recurrenceType"),
        startTime = startTime,
    )
}
