@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Action Groups information, used by the alert rule.
 * @property customEmailSubject An optional custom email subject to use in email notifications.
 * @property customWebhookPayload An optional custom web-hook payload to use in web-hook notifications.
 * @property groupIds The Action Group resource IDs.
 */
public data class ActionGroupsInformationResponse(
    public val customEmailSubject: String? = null,
    public val customWebhookPayload: String? = null,
    public val groupIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.ActionGroupsInformationResponse): ActionGroupsInformationResponse = ActionGroupsInformationResponse(
            customEmailSubject = javaType.customEmailSubject().map({ args0 -> args0 }).orElse(null),
            customWebhookPayload = javaType.customWebhookPayload().map({ args0 -> args0 }).orElse(null),
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
        )
    }
}
