@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Add action groups to alert processing rule.
 * @property actionGroupIds List of action group Ids to add to alert processing rule.
 * @property actionType Action that should be applied.
 * Expected value is 'AddActionGroups'.
 */
public data class AddActionGroupsResponse(
    public val actionGroupIds: List<String>,
    public val actionType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.AddActionGroupsResponse): AddActionGroupsResponse = AddActionGroupsResponse(
            actionGroupIds = javaType.actionGroupIds().map({ args0 -> args0 }),
            actionType = javaType.actionType(),
        )
    }
}
