@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Alert processing rule properties defining scopes, conditions and scheduling logic for alert processing rule.
 * @property actions Actions to be applied.
 * @property conditions Conditions on which alerts will be filtered.
 * @property description Description of alert processing rule.
 * @property enabled Indicates if the given alert processing rule is enabled or disabled.
 * @property schedule Scheduling for alert processing rule.
 * @property scopes Scopes on which alert processing rule will apply.
 */
public data class AlertProcessingRulePropertiesResponse(
    public val actions: List<Either<AddActionGroupsResponse, RemoveAllActionGroupsResponse>>,
    public val conditions: List<ConditionResponse>? = null,
    public val description: String? = null,
    public val enabled: Boolean? = null,
    public val schedule: ScheduleResponse? = null,
    public val scopes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.AlertProcessingRulePropertiesResponse): AlertProcessingRulePropertiesResponse = AlertProcessingRulePropertiesResponse(
            actions = javaType.actions().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.alertsmanagement.kotlin.outputs.AddActionGroupsResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.alertsmanagement.kotlin.outputs.RemoveAllActionGroupsResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scopes = javaType.scopes().map({ args0 -> args0 }),
        )
    }
}
