@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Condition to trigger an alert processing rule.
 * @property field Field for a given condition.
 * @property operator Operator for a given condition.
 * @property values List of values to match for a given condition.
 */
public data class ConditionResponse(
    public val `field`: String? = null,
    public val `operator`: String? = null,
    public val values: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.ConditionResponse): ConditionResponse = ConditionResponse(
            `field` = javaType.`field`().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
