@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Daily recurrence object.
 * @property endTime End time for recurrence.
 * @property recurrenceType Specifies when the recurrence should be applied.
 * Expected value is 'Daily'.
 * @property startTime Start time for recurrence.
 */
public data class DailyRecurrenceResponse(
    public val endTime: String,
    public val recurrenceType: String,
    public val startTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.DailyRecurrenceResponse): DailyRecurrenceResponse = DailyRecurrenceResponse(
            endTime = javaType.endTime(),
            recurrenceType = javaType.recurrenceType(),
            startTime = javaType.startTime(),
        )
    }
}
