@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The detector parameter definition.
 * @property description The detector parameter description.
 * @property displayName The detector parameter display name.
 * @property isMandatory A value indicating whether this detector parameter is mandatory.
 * @property name The detector parameter name.
 * @property type The detector parameter type.
 */
public data class DetectorParameterDefinitionResponse(
    public val description: String? = null,
    public val displayName: String? = null,
    public val isMandatory: Boolean? = null,
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.DetectorParameterDefinitionResponse): DetectorParameterDefinitionResponse = DetectorParameterDefinitionResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            isMandatory = javaType.isMandatory().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
