@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Action rule object containing target scope, conditions and suppression logic
 * @property id Azure resource Id
 * @property location Resource location
 * @property name Azure resource name
 * @property properties action rule properties
 * @property tags Resource tags
 * @property type Azure resource type
 */
public data class GetActionRuleByNameResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: Any,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.GetActionRuleByNameResult): GetActionRuleByNameResult = GetActionRuleByNameResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
