@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Prometheus rule group resource.
 * @property clusterName Apply rule to data from a specific cluster.
 * @property description Rule group description.
 * @property enabled Enable/disable rule group.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property interval The interval in which to run the Prometheus rule group represented in ISO 8601 duration format. Should be between 1 and 15 minutes
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property rules Defines the rules in the Prometheus rule group.
 * @property scopes Target Azure Monitor workspaces resource ids. This api-version is currently limited to creating with one scope. This may change in future.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPrometheusRuleGroupResult(
    public val clusterName: String? = null,
    public val description: String? = null,
    public val enabled: Boolean? = null,
    public val id: String,
    public val interval: String? = null,
    public val location: String,
    public val name: String,
    public val rules: List<PrometheusRuleResponse>,
    public val scopes: List<String>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.GetPrometheusRuleGroupResult): GetPrometheusRuleGroupResult = GetPrometheusRuleGroupResult(
            clusterName = javaType.clusterName().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.PrometheusRuleResponse.Companion.toKotlin(args0)
                })
            }),
            scopes = javaType.scopes().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.alertsmanagement.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
