@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An alert action. Only relevant for alerts.
 * @property actionGroupId The resource id of the action group to use.
 * @property actionProperties The properties of an action group object.
 */
public data class PrometheusRuleGroupActionResponse(
    public val actionGroupId: String? = null,
    public val actionProperties: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.PrometheusRuleGroupActionResponse): PrometheusRuleGroupActionResponse = PrometheusRuleGroupActionResponse(
            actionGroupId = javaType.actionGroupId().map({ args0 -> args0 }).orElse(null),
            actionProperties = javaType.actionProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
