@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the Prometheus alert rule configuration.
 * @property autoResolved Enable alert auto-resolution.
 * @property timeToResolve Alert auto-resolution timeout.
 */
public data class PrometheusRuleResolveConfigurationResponse(
    public val autoResolved: Boolean? = null,
    public val timeToResolve: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.PrometheusRuleResolveConfigurationResponse): PrometheusRuleResolveConfigurationResponse = PrometheusRuleResolveConfigurationResponse(
            autoResolved = javaType.autoResolved().map({ args0 -> args0 }).orElse(null),
            timeToResolve = javaType.timeToResolve().map({ args0 -> args0 }).orElse(null),
        )
    }
}
