@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Azure Prometheus alerting or recording rule.
 * @property actions Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
 * @property alert Alert rule name.
 * @property annotations The annotations clause specifies a set of informational labels that can be used to store longer additional information such as alert descriptions or runbook links. The annotation values can be templated.
 * @property enabled Enable/disable rule.
 * @property expression The PromQL expression to evaluate. https://prometheus.io/docs/prometheus/latest/querying/basics/. Evaluated periodically as given by 'interval', and the result recorded as a new set of time series with the metric name as given by 'record'.
 * @property for The amount of time alert must be active before firing.
 * @property labels Labels to add or overwrite before storing the result.
 * @property record Recorded metrics name.
 * @property resolveConfiguration Defines the configuration for resolving fired alerts. Only relevant for alerts.
 * @property severity The severity of the alerts fired by the rule. Must be between 0 and 4.
 */
public data class PrometheusRuleResponse(
    public val actions: List<PrometheusRuleGroupActionResponse>? = null,
    public val alert: String? = null,
    public val annotations: Map<String, String>? = null,
    public val enabled: Boolean? = null,
    public val expression: String,
    public val `for`: String? = null,
    public val labels: Map<String, String>? = null,
    public val record: String? = null,
    public val resolveConfiguration: PrometheusRuleResolveConfigurationResponse? = null,
    public val severity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.PrometheusRuleResponse): PrometheusRuleResponse = PrometheusRuleResponse(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.PrometheusRuleGroupActionResponse.Companion.toKotlin(args0)
                })
            }),
            alert = javaType.alert().map({ args0 -> args0 }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            expression = javaType.expression(),
            `for` = javaType.for_().map({ args0 -> args0 }).orElse(null),
            labels = javaType.labels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            record = javaType.record().map({ args0 -> args0 }).orElse(null),
            resolveConfiguration = javaType.resolveConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.PrometheusRuleResolveConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            severity = javaType.severity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
