@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Suppression logic for a given action rule
 * @property recurrenceType Specifies when the suppression should be applied
 * @property schedule suppression schedule configuration
 */
public data class SuppressionConfigResponse(
    public val recurrenceType: String,
    public val schedule: SuppressionScheduleResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.SuppressionConfigResponse): SuppressionConfigResponse = SuppressionConfigResponse(
            recurrenceType = javaType.recurrenceType(),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.SuppressionScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
