@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Optional throttling information for the alert rule.
 * @property duration The required duration (in ISO8601 format) to wait before notifying on the alert rule again. The time granularity must be in minutes and minimum value is 0 minutes
 */
public data class ThrottlingInformationResponse(
    public val duration: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.ThrottlingInformationResponse): ThrottlingInformationResponse = ThrottlingInformationResponse(
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
        )
    }
}
