@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Weekly recurrence object.
 * @property daysOfWeek Specifies the values for weekly recurrence pattern.
 * @property endTime End time for recurrence.
 * @property recurrenceType Specifies when the recurrence should be applied.
 * Expected value is 'Weekly'.
 * @property startTime Start time for recurrence.
 */
public data class WeeklyRecurrenceResponse(
    public val daysOfWeek: List<String>,
    public val endTime: String? = null,
    public val recurrenceType: String,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.WeeklyRecurrenceResponse): WeeklyRecurrenceResponse = WeeklyRecurrenceResponse(
            daysOfWeek = javaType.daysOfWeek().map({ args0 -> args0 }),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            recurrenceType = javaType.recurrenceType(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
