@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The name of the Azure pricing tier to which the SKU applies.
 */
public enum class SkuTier(
    public val javaValue: com.pulumi.azurenative.analysisservices.enums.SkuTier,
) : ConvertibleToJava<com.pulumi.azurenative.analysisservices.enums.SkuTier> {
    Development(com.pulumi.azurenative.analysisservices.enums.SkuTier.Development),
    Basic(com.pulumi.azurenative.analysisservices.enums.SkuTier.Basic),
    Standard(com.pulumi.azurenative.analysisservices.enums.SkuTier.Standard),
    ;

    override fun toJava(): com.pulumi.azurenative.analysisservices.enums.SkuTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.analysisservices.enums.SkuTier): SkuTier =
            SkuTier.values().first { it.javaValue == javaType }
    }
}
