@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.inputs

import com.pulumi.azurenative.analysisservices.inputs.IPv4FirewallSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An array of firewall rules.
 * @property enablePowerBIService The indicator of enabling PBI service.
 * @property firewallRules An array of firewall rules.
 */
public data class IPv4FirewallSettingsArgs(
    public val enablePowerBIService: Output<Boolean>? = null,
    public val firewallRules: Output<List<IPv4FirewallRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.analysisservices.inputs.IPv4FirewallSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.analysisservices.inputs.IPv4FirewallSettingsArgs =
        com.pulumi.azurenative.analysisservices.inputs.IPv4FirewallSettingsArgs.builder()
            .enablePowerBIService(enablePowerBIService?.applyValue({ args0 -> args0 }))
            .firewallRules(
                firewallRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IPv4FirewallSettingsArgs].
 */
@PulumiTagMarker
public class IPv4FirewallSettingsArgsBuilder internal constructor() {
    private var enablePowerBIService: Output<Boolean>? = null

    private var firewallRules: Output<List<IPv4FirewallRuleArgs>>? = null

    /**
     * @param value The indicator of enabling PBI service.
     */
    @JvmName("hhwoiafnbcndootn")
    public suspend fun enablePowerBIService(`value`: Output<Boolean>) {
        this.enablePowerBIService = value
    }

    /**
     * @param value An array of firewall rules.
     */
    @JvmName("lbvqapsmjlciumki")
    public suspend fun firewallRules(`value`: Output<List<IPv4FirewallRuleArgs>>) {
        this.firewallRules = value
    }

    @JvmName("jgfnowvkxismyxay")
    public suspend fun firewallRules(vararg values: Output<IPv4FirewallRuleArgs>) {
        this.firewallRules = Output.all(values.asList())
    }

    /**
     * @param values An array of firewall rules.
     */
    @JvmName("osgfjrwgadlpwvbg")
    public suspend fun firewallRules(values: List<Output<IPv4FirewallRuleArgs>>) {
        this.firewallRules = Output.all(values)
    }

    /**
     * @param value The indicator of enabling PBI service.
     */
    @JvmName("uqxvusrghacoptin")
    public suspend fun enablePowerBIService(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePowerBIService = mapped
    }

    /**
     * @param value An array of firewall rules.
     */
    @JvmName("jgucfqbbrrkhmgyf")
    public suspend fun firewallRules(`value`: List<IPv4FirewallRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param argument An array of firewall rules.
     */
    @JvmName("okmgmjyoxtbgvdim")
    public suspend fun firewallRules(argument: List<suspend IPv4FirewallRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IPv4FirewallRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument An array of firewall rules.
     */
    @JvmName("yvdgtvvoscpwnenl")
    public suspend fun firewallRules(vararg argument: suspend IPv4FirewallRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IPv4FirewallRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument An array of firewall rules.
     */
    @JvmName("rpwstlddjejtnvwx")
    public suspend fun firewallRules(argument: suspend IPv4FirewallRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPv4FirewallRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param values An array of firewall rules.
     */
    @JvmName("euuvffhvguuekias")
    public suspend fun firewallRules(vararg values: IPv4FirewallRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    internal fun build(): IPv4FirewallSettingsArgs = IPv4FirewallSettingsArgs(
        enablePowerBIService = enablePowerBIService,
        firewallRules = firewallRules,
    )
}
