@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.inputs

import com.pulumi.azurenative.analysisservices.inputs.ListServerGatewayStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the Azure Resource group of which a given Analysis Services server is part. This name must be at least 1 character in length, and no more than 90.
 * @property serverName The name of the Analysis Services server.
 */
public data class ListServerGatewayStatusPlainArgs(
    public val resourceGroupName: String,
    public val serverName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.analysisservices.inputs.ListServerGatewayStatusPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.analysisservices.inputs.ListServerGatewayStatusPlainArgs =
        com.pulumi.azurenative.analysisservices.inputs.ListServerGatewayStatusPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListServerGatewayStatusPlainArgs].
 */
@PulumiTagMarker
public class ListServerGatewayStatusPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the Azure Resource group of which a given Analysis Services server is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("jbxtldrgmehjndlm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Analysis Services server.
     */
    @JvmName("urkpsayrmmtbvxgm")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): ListServerGatewayStatusPlainArgs = ListServerGatewayStatusPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
