@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The gateway details.
 * @property dmtsClusterUri Uri of the DMTS cluster.
 * @property gatewayObjectId Gateway object id from in the DMTS cluster for the gateway resource.
 * @property gatewayResourceId Gateway resource to be associated with the server.
 */
public data class GatewayDetailsResponse(
    public val dmtsClusterUri: String,
    public val gatewayObjectId: String,
    public val gatewayResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.analysisservices.outputs.GatewayDetailsResponse): GatewayDetailsResponse = GatewayDetailsResponse(
            dmtsClusterUri = javaType.dmtsClusterUri(),
            gatewayObjectId = javaType.gatewayObjectId(),
            gatewayResourceId = javaType.gatewayResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
