@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The detail of firewall rule.
 * @property firewallRuleName The rule name.
 * @property rangeEnd The end range of IPv4.
 * @property rangeStart The start range of IPv4.
 */
public data class IPv4FirewallRuleResponse(
    public val firewallRuleName: String? = null,
    public val rangeEnd: String? = null,
    public val rangeStart: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.analysisservices.outputs.IPv4FirewallRuleResponse): IPv4FirewallRuleResponse = IPv4FirewallRuleResponse(
            firewallRuleName = javaType.firewallRuleName().map({ args0 -> args0 }).orElse(null),
            rangeEnd = javaType.rangeEnd().map({ args0 -> args0 }).orElse(null),
            rangeStart = javaType.rangeStart().map({ args0 -> args0 }).orElse(null),
        )
    }
}
