@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * An array of firewall rules.
 * @property enablePowerBIService The indicator of enabling PBI service.
 * @property firewallRules An array of firewall rules.
 */
public data class IPv4FirewallSettingsResponse(
    public val enablePowerBIService: Boolean? = null,
    public val firewallRules: List<IPv4FirewallRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.analysisservices.outputs.IPv4FirewallSettingsResponse): IPv4FirewallSettingsResponse = IPv4FirewallSettingsResponse(
            enablePowerBIService = javaType.enablePowerBIService().map({ args0 -> args0 }).orElse(null),
            firewallRules = javaType.firewallRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.analysisservices.kotlin.outputs.IPv4FirewallRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
