@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.kotlin.outputs.ContactResponse
import com.pulumi.azurenative.apicenter.kotlin.outputs.ExternalDocumentationResponse
import com.pulumi.azurenative.apicenter.kotlin.outputs.LicenseResponse
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.apicenter.kotlin.outputs.TermsOfServiceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.apicenter.kotlin.outputs.ContactResponse.Companion.toKotlin as contactResponseToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.ExternalDocumentationResponse.Companion.toKotlin as externalDocumentationResponseToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.LicenseResponse.Companion.toKotlin as licenseResponseToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.TermsOfServiceResponse.Companion.toKotlin as termsOfServiceResponseToKotlin

/**
 * Builder for [Api].
 */
@PulumiTagMarker
public class ApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiArgs = ApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiArgsBuilder.() -> Unit) {
        val builder = ApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Api {
        val builtJavaResource = com.pulumi.azurenative.apicenter.Api(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Api(builtJavaResource)
    }
}

/**
 * API entity.
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2024-03-15-preview.
 * ## Example Usage
 * ### Apis_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiCenter.Api("api", new()
 *     {
 *         ApiName = "echo-api",
 *         CustomProperties = new Dictionary<string, object?>
 *         {
 *             ["author"] = "John Doe",
 *         },
 *         Description = "A simple HTTP request/response service.",
 *         ExternalDocumentation = new[]
 *         {
 *             new AzureNative.ApiCenter.Inputs.ExternalDocumentationArgs
 *             {
 *                 Title = "Onboarding docs",
 *                 Url = "https://docs.contoso.com",
 *             },
 *         },
 *         Kind = AzureNative.ApiCenter.ApiKind.Rest,
 *         License = new AzureNative.ApiCenter.Inputs.LicenseArgs
 *         {
 *             Url = "https://contoso.com/license",
 *         },
 *         ResourceGroupName = "contoso-resources",
 *         ServiceName = "contoso",
 *         TermsOfService = new AzureNative.ApiCenter.Inputs.TermsOfServiceArgs
 *         {
 *             Url = "https://contoso.com/terms-of-service",
 *         },
 *         Title = "Echo API",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewApi(ctx, "api", &apicenter.ApiArgs{
 * 			ApiName: pulumi.String("echo-api"),
 * 			CustomProperties: pulumi.Any(map[string]interface{}{
 * 				"author": "John Doe",
 * 			}),
 * 			Description: pulumi.String("A simple HTTP request/response service."),
 * 			ExternalDocumentation: apicenter.ExternalDocumentationArray{
 * 				&apicenter.ExternalDocumentationArgs{
 * 					Title: pulumi.String("Onboarding docs"),
 * 					Url:   pulumi.String("https://docs.contoso.com"),
 * 				},
 * 			},
 * 			Kind: pulumi.String(apicenter.ApiKindRest),
 * 			License: &apicenter.LicenseArgs{
 * 				Url: pulumi.String("https://contoso.com/license"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			ServiceName:       pulumi.String("contoso"),
 * 			TermsOfService: &apicenter.TermsOfServiceArgs{
 * 				Url: pulumi.String("https://contoso.com/terms-of-service"),
 * 			},
 * 			Title:         pulumi.String("Echo API"),
 * 			WorkspaceName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.Api;
 * import com.pulumi.azurenative.apicenter.ApiArgs;
 * import com.pulumi.azurenative.apicenter.inputs.ExternalDocumentationArgs;
 * import com.pulumi.azurenative.apicenter.inputs.LicenseArgs;
 * import com.pulumi.azurenative.apicenter.inputs.TermsOfServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiName("echo-api")
 *             .customProperties(Map.of("author", "John Doe"))
 *             .description("A simple HTTP request/response service.")
 *             .externalDocumentation(ExternalDocumentationArgs.builder()
 *                 .title("Onboarding docs")
 *                 .url("https://docs.contoso.com")
 *                 .build())
 *             .kind("rest")
 *             .license(LicenseArgs.builder()
 *                 .url("https://contoso.com/license")
 *                 .build())
 *             .resourceGroupName("contoso-resources")
 *             .serviceName("contoso")
 *             .termsOfService(TermsOfServiceArgs.builder()
 *                 .url("https://contoso.com/terms-of-service")
 *                 .build())
 *             .title("Echo API")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:Api echo-api /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}
 * ```
 */
public class Api internal constructor(
    override val javaResource: com.pulumi.azurenative.apicenter.Api,
) : KotlinCustomResource(javaResource, ApiMapper) {
    /**
     * The set of contacts
     */
    public val contacts: Output<List<ContactResponse>>?
        get() = javaResource.contacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> contactResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The custom metadata defined for API catalog entities.
     */
    public val customProperties: Output<Any>?
        get() = javaResource.customProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the API.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The set of external documentation
     */
    public val externalDocumentation: Output<List<ExternalDocumentationResponse>>?
        get() = javaResource.externalDocumentation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        externalDocumentationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Kind of API. For example, REST or GraphQL.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The license information for the API.
     */
    public val license: Output<LicenseResponse>?
        get() = javaResource.license().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    licenseResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Current lifecycle stage of the API.
     */
    public val lifecycleStage: Output<String>
        get() = javaResource.lifecycleStage().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Short description of the API.
     */
    public val summary: Output<String>?
        get() = javaResource.summary().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Terms of service for the API.
     */
    public val termsOfService: Output<TermsOfServiceResponse>?
        get() = javaResource.termsOfService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> termsOfServiceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * API title.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApiMapper : ResourceMapper<Api> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apicenter.Api::class == javaResource::class

    override fun map(javaResource: Resource): Api = Api(
        javaResource as
            com.pulumi.azurenative.apicenter.Api,
    )
}

/**
 * @see [Api].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Api].
 */
public suspend fun api(name: String, block: suspend ApiResourceBuilder.() -> Unit): Api {
    val builder = ApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Api].
 * @param name The _unique_ name of the resulting resource.
 */
public fun api(name: String): Api {
    val builder = ApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
