@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.ApiArgs.builder
import com.pulumi.azurenative.apicenter.kotlin.enums.ApiKind
import com.pulumi.azurenative.apicenter.kotlin.inputs.ContactArgs
import com.pulumi.azurenative.apicenter.kotlin.inputs.ContactArgsBuilder
import com.pulumi.azurenative.apicenter.kotlin.inputs.ExternalDocumentationArgs
import com.pulumi.azurenative.apicenter.kotlin.inputs.ExternalDocumentationArgsBuilder
import com.pulumi.azurenative.apicenter.kotlin.inputs.LicenseArgs
import com.pulumi.azurenative.apicenter.kotlin.inputs.LicenseArgsBuilder
import com.pulumi.azurenative.apicenter.kotlin.inputs.TermsOfServiceArgs
import com.pulumi.azurenative.apicenter.kotlin.inputs.TermsOfServiceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API entity.
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2024-03-15-preview.
 * ## Example Usage
 * ### Apis_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var api = new AzureNative.ApiCenter.Api("api", new()
 *     {
 *         ApiName = "echo-api",
 *         CustomProperties = new Dictionary<string, object?>
 *         {
 *             ["author"] = "John Doe",
 *         },
 *         Description = "A simple HTTP request/response service.",
 *         ExternalDocumentation = new[]
 *         {
 *             new AzureNative.ApiCenter.Inputs.ExternalDocumentationArgs
 *             {
 *                 Title = "Onboarding docs",
 *                 Url = "https://docs.contoso.com",
 *             },
 *         },
 *         Kind = AzureNative.ApiCenter.ApiKind.Rest,
 *         License = new AzureNative.ApiCenter.Inputs.LicenseArgs
 *         {
 *             Url = "https://contoso.com/license",
 *         },
 *         ResourceGroupName = "contoso-resources",
 *         ServiceName = "contoso",
 *         TermsOfService = new AzureNative.ApiCenter.Inputs.TermsOfServiceArgs
 *         {
 *             Url = "https://contoso.com/terms-of-service",
 *         },
 *         Title = "Echo API",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewApi(ctx, "api", &apicenter.ApiArgs{
 * 			ApiName: pulumi.String("echo-api"),
 * 			CustomProperties: pulumi.Any(map[string]interface{}{
 * 				"author": "John Doe",
 * 			}),
 * 			Description: pulumi.String("A simple HTTP request/response service."),
 * 			ExternalDocumentation: apicenter.ExternalDocumentationArray{
 * 				&apicenter.ExternalDocumentationArgs{
 * 					Title: pulumi.String("Onboarding docs"),
 * 					Url:   pulumi.String("https://docs.contoso.com"),
 * 				},
 * 			},
 * 			Kind: pulumi.String(apicenter.ApiKindRest),
 * 			License: &apicenter.LicenseArgs{
 * 				Url: pulumi.String("https://contoso.com/license"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			ServiceName:       pulumi.String("contoso"),
 * 			TermsOfService: &apicenter.TermsOfServiceArgs{
 * 				Url: pulumi.String("https://contoso.com/terms-of-service"),
 * 			},
 * 			Title:         pulumi.String("Echo API"),
 * 			WorkspaceName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.Api;
 * import com.pulumi.azurenative.apicenter.ApiArgs;
 * import com.pulumi.azurenative.apicenter.inputs.ExternalDocumentationArgs;
 * import com.pulumi.azurenative.apicenter.inputs.LicenseArgs;
 * import com.pulumi.azurenative.apicenter.inputs.TermsOfServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var api = new Api("api", ApiArgs.builder()
 *             .apiName("echo-api")
 *             .customProperties(Map.of("author", "John Doe"))
 *             .description("A simple HTTP request/response service.")
 *             .externalDocumentation(ExternalDocumentationArgs.builder()
 *                 .title("Onboarding docs")
 *                 .url("https://docs.contoso.com")
 *                 .build())
 *             .kind("rest")
 *             .license(LicenseArgs.builder()
 *                 .url("https://contoso.com/license")
 *                 .build())
 *             .resourceGroupName("contoso-resources")
 *             .serviceName("contoso")
 *             .termsOfService(TermsOfServiceArgs.builder()
 *                 .url("https://contoso.com/terms-of-service")
 *                 .build())
 *             .title("Echo API")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:Api echo-api /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}
 * ```
 * @property apiName The name of the API.
 * @property contacts The set of contacts
 * @property customProperties The custom metadata defined for API catalog entities.
 * @property description Description of the API.
 * @property externalDocumentation The set of external documentation
 * @property kind Kind of API. For example, REST or GraphQL.
 * @property license The license information for the API.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 * @property summary Short description of the API.
 * @property termsOfService Terms of service for the API.
 * @property title API title.
 * @property workspaceName The name of the workspace.
 */
public data class ApiArgs(
    public val apiName: Output<String>? = null,
    public val contacts: Output<List<ContactArgs>>? = null,
    public val customProperties: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val externalDocumentation: Output<List<ExternalDocumentationArgs>>? = null,
    public val kind: Output<Either<String, ApiKind>>? = null,
    public val license: Output<LicenseArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val summary: Output<String>? = null,
    public val termsOfService: Output<TermsOfServiceArgs>? = null,
    public val title: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.ApiArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.ApiArgs =
        com.pulumi.azurenative.apicenter.ApiArgs.builder()
            .apiName(apiName?.applyValue({ args0 -> args0 }))
            .contacts(
                contacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .customProperties(customProperties?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .externalDocumentation(
                externalDocumentation?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .license(license?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .summary(summary?.applyValue({ args0 -> args0 }))
            .termsOfService(termsOfService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .title(title?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiArgs].
 */
@PulumiTagMarker
public class ApiArgsBuilder internal constructor() {
    private var apiName: Output<String>? = null

    private var contacts: Output<List<ContactArgs>>? = null

    private var customProperties: Output<Any>? = null

    private var description: Output<String>? = null

    private var externalDocumentation: Output<List<ExternalDocumentationArgs>>? = null

    private var kind: Output<Either<String, ApiKind>>? = null

    private var license: Output<LicenseArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var summary: Output<String>? = null

    private var termsOfService: Output<TermsOfServiceArgs>? = null

    private var title: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the API.
     */
    @JvmName("eabrmegpntxsvoax")
    public suspend fun apiName(`value`: Output<String>) {
        this.apiName = value
    }

    /**
     * @param value The set of contacts
     */
    @JvmName("hwcoofndafasmoea")
    public suspend fun contacts(`value`: Output<List<ContactArgs>>) {
        this.contacts = value
    }

    @JvmName("qdrjtjngqoixtvya")
    public suspend fun contacts(vararg values: Output<ContactArgs>) {
        this.contacts = Output.all(values.asList())
    }

    /**
     * @param values The set of contacts
     */
    @JvmName("qoysteknpsvusgfy")
    public suspend fun contacts(values: List<Output<ContactArgs>>) {
        this.contacts = Output.all(values)
    }

    /**
     * @param value The custom metadata defined for API catalog entities.
     */
    @JvmName("diavwpdakqxoxaih")
    public suspend fun customProperties(`value`: Output<Any>) {
        this.customProperties = value
    }

    /**
     * @param value Description of the API.
     */
    @JvmName("cuyygyiggevpdqop")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The set of external documentation
     */
    @JvmName("qhpjloxudnxrdtxs")
    public suspend fun externalDocumentation(`value`: Output<List<ExternalDocumentationArgs>>) {
        this.externalDocumentation = value
    }

    @JvmName("qcsgwxudirbxyxkn")
    public suspend fun externalDocumentation(vararg values: Output<ExternalDocumentationArgs>) {
        this.externalDocumentation = Output.all(values.asList())
    }

    /**
     * @param values The set of external documentation
     */
    @JvmName("nsscrldlmnwdgqcu")
    public suspend fun externalDocumentation(values: List<Output<ExternalDocumentationArgs>>) {
        this.externalDocumentation = Output.all(values)
    }

    /**
     * @param value Kind of API. For example, REST or GraphQL.
     */
    @JvmName("hoevnjpttbjyfgpd")
    public suspend fun kind(`value`: Output<Either<String, ApiKind>>) {
        this.kind = value
    }

    /**
     * @param value The license information for the API.
     */
    @JvmName("ddywjtkkobevwhlo")
    public suspend fun license(`value`: Output<LicenseArgs>) {
        this.license = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pxsuvlulexlofeja")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("efwdgqwwdblelrhk")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Short description of the API.
     */
    @JvmName("ibsvcqxtetdvsobe")
    public suspend fun summary(`value`: Output<String>) {
        this.summary = value
    }

    /**
     * @param value Terms of service for the API.
     */
    @JvmName("qewmwqysvspwmlfd")
    public suspend fun termsOfService(`value`: Output<TermsOfServiceArgs>) {
        this.termsOfService = value
    }

    /**
     * @param value API title.
     */
    @JvmName("ntqrgeiosaumixey")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("yxtklxqydtglaimt")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the API.
     */
    @JvmName("ybexweeoqkbureus")
    public suspend fun apiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiName = mapped
    }

    /**
     * @param value The set of contacts
     */
    @JvmName("txpuskhgjlclfidx")
    public suspend fun contacts(`value`: List<ContactArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contacts = mapped
    }

    /**
     * @param argument The set of contacts
     */
    @JvmName("kenooyxotcqhmduu")
    public suspend fun contacts(argument: List<suspend ContactArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ContactArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.contacts = mapped
    }

    /**
     * @param argument The set of contacts
     */
    @JvmName("bdufmkdppsxijbuk")
    public suspend fun contacts(vararg argument: suspend ContactArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ContactArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.contacts = mapped
    }

    /**
     * @param argument The set of contacts
     */
    @JvmName("xkcrludaqptlqenq")
    public suspend fun contacts(argument: suspend ContactArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContactArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.contacts = mapped
    }

    /**
     * @param values The set of contacts
     */
    @JvmName("bmytevdgkngoksxc")
    public suspend fun contacts(vararg values: ContactArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contacts = mapped
    }

    /**
     * @param value The custom metadata defined for API catalog entities.
     */
    @JvmName("oofdyknqfivpfvnl")
    public suspend fun customProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Description of the API.
     */
    @JvmName("elvmleknvjvsprut")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The set of external documentation
     */
    @JvmName("qerdjeqywbykayvu")
    public suspend fun externalDocumentation(`value`: List<ExternalDocumentationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalDocumentation = mapped
    }

    /**
     * @param argument The set of external documentation
     */
    @JvmName("osjfyfuyaucyqegb")
    public suspend fun externalDocumentation(argument: List<suspend ExternalDocumentationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExternalDocumentationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.externalDocumentation = mapped
    }

    /**
     * @param argument The set of external documentation
     */
    @JvmName("lwmlhvpfncbeayft")
    public suspend fun externalDocumentation(vararg argument: suspend ExternalDocumentationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExternalDocumentationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.externalDocumentation = mapped
    }

    /**
     * @param argument The set of external documentation
     */
    @JvmName("vkilbvuaaoywyuah")
    public suspend fun externalDocumentation(argument: suspend ExternalDocumentationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExternalDocumentationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.externalDocumentation = mapped
    }

    /**
     * @param values The set of external documentation
     */
    @JvmName("ddipqtsfmxmvhexx")
    public suspend fun externalDocumentation(vararg values: ExternalDocumentationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalDocumentation = mapped
    }

    /**
     * @param value Kind of API. For example, REST or GraphQL.
     */
    @JvmName("ekoawpqgeccysfag")
    public suspend fun kind(`value`: Either<String, ApiKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Kind of API. For example, REST or GraphQL.
     */
    @JvmName("ygtxeemwccfjnjkc")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApiKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Kind of API. For example, REST or GraphQL.
     */
    @JvmName("obmsgvyyntrastaj")
    public fun kind(`value`: ApiKind) {
        val toBeMapped = Either.ofRight<String, ApiKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The license information for the API.
     */
    @JvmName("gchqmkvnfyianbsg")
    public suspend fun license(`value`: LicenseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.license = mapped
    }

    /**
     * @param argument The license information for the API.
     */
    @JvmName("fkriwaummsklxjbk")
    public suspend fun license(argument: suspend LicenseArgsBuilder.() -> Unit) {
        val toBeMapped = LicenseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.license = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kdixqryuyvkqrfdj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("wuatpsoegjsehkiw")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Short description of the API.
     */
    @JvmName("kuutmuvarncgoidj")
    public suspend fun summary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summary = mapped
    }

    /**
     * @param value Terms of service for the API.
     */
    @JvmName("rtukprqbspqssaod")
    public suspend fun termsOfService(`value`: TermsOfServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.termsOfService = mapped
    }

    /**
     * @param argument Terms of service for the API.
     */
    @JvmName("ohsidsuqiqmokixd")
    public suspend fun termsOfService(argument: suspend TermsOfServiceArgsBuilder.() -> Unit) {
        val toBeMapped = TermsOfServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.termsOfService = mapped
    }

    /**
     * @param value API title.
     */
    @JvmName("tbcvtkquwqqyfddq")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("euhemwbicvwwnrhn")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ApiArgs = ApiArgs(
        apiName = apiName,
        contacts = contacts,
        customProperties = customProperties,
        description = description,
        externalDocumentation = externalDocumentation,
        kind = kind,
        license = license,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        summary = summary,
        termsOfService = termsOfService,
        title = title,
        workspaceName = workspaceName,
    )
}
