@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.ApiDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API definition entity.
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2024-03-15-preview.
 * ## Example Usage
 * ### ApiDefinitions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiDefinition = new AzureNative.ApiCenter.ApiDefinition("apiDefinition", new()
 *     {
 *         ApiName = "openapi",
 *         DefinitionName = "openapi",
 *         Description = "Default spec",
 *         ResourceGroupName = "contoso-resources",
 *         ServiceName = "contoso",
 *         Title = "OpenAPI",
 *         VersionName = "2023-01-01",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewApiDefinition(ctx, "apiDefinition", &apicenter.ApiDefinitionArgs{
 * 			ApiName:           pulumi.String("openapi"),
 * 			DefinitionName:    pulumi.String("openapi"),
 * 			Description:       pulumi.String("Default spec"),
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			ServiceName:       pulumi.String("contoso"),
 * 			Title:             pulumi.String("OpenAPI"),
 * 			VersionName:       pulumi.String("2023-01-01"),
 * 			WorkspaceName:     pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.ApiDefinition;
 * import com.pulumi.azurenative.apicenter.ApiDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiDefinition = new ApiDefinition("apiDefinition", ApiDefinitionArgs.builder()
 *             .apiName("openapi")
 *             .definitionName("openapi")
 *             .description("Default spec")
 *             .resourceGroupName("contoso-resources")
 *             .serviceName("contoso")
 *             .title("OpenAPI")
 *             .versionName("2023-01-01")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:ApiDefinition openapi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions/{definitionName}
 * ```
 * @property apiName The name of the API.
 * @property definitionName The name of the API definition.
 * @property description API definition description.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 * @property title API definition title.
 * @property versionName The name of the API version.
 * @property workspaceName The name of the workspace.
 */
public data class ApiDefinitionArgs(
    public val apiName: Output<String>? = null,
    public val definitionName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val title: Output<String>? = null,
    public val versionName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.ApiDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.ApiDefinitionArgs =
        com.pulumi.azurenative.apicenter.ApiDefinitionArgs.builder()
            .apiName(apiName?.applyValue({ args0 -> args0 }))
            .definitionName(definitionName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .versionName(versionName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiDefinitionArgs].
 */
@PulumiTagMarker
public class ApiDefinitionArgsBuilder internal constructor() {
    private var apiName: Output<String>? = null

    private var definitionName: Output<String>? = null

    private var description: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var title: Output<String>? = null

    private var versionName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the API.
     */
    @JvmName("njfcdwsutbjpjcvr")
    public suspend fun apiName(`value`: Output<String>) {
        this.apiName = value
    }

    /**
     * @param value The name of the API definition.
     */
    @JvmName("femrexsybrienohg")
    public suspend fun definitionName(`value`: Output<String>) {
        this.definitionName = value
    }

    /**
     * @param value API definition description.
     */
    @JvmName("qqaysykfdraedgho")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dgetewklgyyyjxmt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("xyqssfampahbtxpb")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value API definition title.
     */
    @JvmName("sbhdjdktcytkbnoq")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The name of the API version.
     */
    @JvmName("bwaaohmqxbkrgfiw")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("goosrojcdkxxrwpl")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the API.
     */
    @JvmName("vwsnjagqlhsocfgx")
    public suspend fun apiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiName = mapped
    }

    /**
     * @param value The name of the API definition.
     */
    @JvmName("drctbjtfbdyubgxk")
    public suspend fun definitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definitionName = mapped
    }

    /**
     * @param value API definition description.
     */
    @JvmName("pyqwosujwtkodjtl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tgrljpnambvbscjo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("yehpyuqjrktpgeuo")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value API definition title.
     */
    @JvmName("pgtqnldnuhyjebca")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The name of the API version.
     */
    @JvmName("tbpsnqmvsjuaikek")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ikavwbiylpnstjbb")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ApiDefinitionArgs = ApiDefinitionArgs(
        apiName = apiName,
        definitionName = definitionName,
        description = description,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        title = title,
        versionName = versionName,
        workspaceName = workspaceName,
    )
}
