@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Current lifecycle stage of the API.
 */
public enum class LifecycleStage(
    public val javaValue: com.pulumi.azurenative.apicenter.enums.LifecycleStage,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.enums.LifecycleStage> {
    /**
     * design stage
     */
    Design(com.pulumi.azurenative.apicenter.enums.LifecycleStage.Design),

    /**
     * development stage
     */
    Development(com.pulumi.azurenative.apicenter.enums.LifecycleStage.Development),

    /**
     * testing stage
     */
    Testing(com.pulumi.azurenative.apicenter.enums.LifecycleStage.Testing),

    /**
     * In preview
     */
    Preview(com.pulumi.azurenative.apicenter.enums.LifecycleStage.Preview),

    /**
     * In production
     */
    Production(com.pulumi.azurenative.apicenter.enums.LifecycleStage.Production),

    /**
     * deprecated stage
     */
    Deprecated(com.pulumi.azurenative.apicenter.enums.LifecycleStage.Deprecated),

    /**
     * Retired stage
     */
    Retired(com.pulumi.azurenative.apicenter.enums.LifecycleStage.Retired),
    ;

    override fun toJava(): com.pulumi.azurenative.apicenter.enums.LifecycleStage = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.enums.LifecycleStage): LifecycleStage = LifecycleStage.values().first { it.javaValue == javaType }
    }
}
