@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.ContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contact information
 * @property email Email address of the contact.
 * @property name Name of the contact.
 * @property url URL for the contact.
 */
public data class ContactArgs(
    public val email: Output<String>? = null,
    public val name: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.ContactArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.ContactArgs =
        com.pulumi.azurenative.apicenter.inputs.ContactArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactArgs].
 */
@PulumiTagMarker
public class ContactArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var name: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value Email address of the contact.
     */
    @JvmName("vuqqtfivbyjlofrn")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Name of the contact.
     */
    @JvmName("jhgwvjckvlsyabtf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value URL for the contact.
     */
    @JvmName("nbdwaafdvegjhxct")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Email address of the contact.
     */
    @JvmName("uvcyqpksdvkikwxs")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Name of the contact.
     */
    @JvmName("qtbdjklgcnidspoo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value URL for the contact.
     */
    @JvmName("hkqjhxyrcrkukenm")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ContactArgs = ContactArgs(
        email = email,
        name = name,
        url = url,
    )
}
