@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.EnvironmentServerArgs.builder
import com.pulumi.azurenative.apicenter.kotlin.enums.EnvironmentServerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Server information of the environment.
 * @property managementPortalUri The location of the management portal
 * @property type Type of the server that represents the environment.
 */
public data class EnvironmentServerArgs(
    public val managementPortalUri: Output<List<String>>? = null,
    public val type: Output<Either<String, EnvironmentServerType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.EnvironmentServerArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.EnvironmentServerArgs =
        com.pulumi.azurenative.apicenter.inputs.EnvironmentServerArgs.builder()
            .managementPortalUri(managementPortalUri?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EnvironmentServerArgs].
 */
@PulumiTagMarker
public class EnvironmentServerArgsBuilder internal constructor() {
    private var managementPortalUri: Output<List<String>>? = null

    private var type: Output<Either<String, EnvironmentServerType>>? = null

    /**
     * @param value The location of the management portal
     */
    @JvmName("crtqwnoputtsfija")
    public suspend fun managementPortalUri(`value`: Output<List<String>>) {
        this.managementPortalUri = value
    }

    @JvmName("xnwefuhotdqwpklb")
    public suspend fun managementPortalUri(vararg values: Output<String>) {
        this.managementPortalUri = Output.all(values.asList())
    }

    /**
     * @param values The location of the management portal
     */
    @JvmName("aumafocekiqlbwem")
    public suspend fun managementPortalUri(values: List<Output<String>>) {
        this.managementPortalUri = Output.all(values)
    }

    /**
     * @param value Type of the server that represents the environment.
     */
    @JvmName("ibtdfqxrgfidynrv")
    public suspend fun type(`value`: Output<Either<String, EnvironmentServerType>>) {
        this.type = value
    }

    /**
     * @param value The location of the management portal
     */
    @JvmName("pffjerobainscyil")
    public suspend fun managementPortalUri(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementPortalUri = mapped
    }

    /**
     * @param values The location of the management portal
     */
    @JvmName("teluncfuaxgttdwi")
    public suspend fun managementPortalUri(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementPortalUri = mapped
    }

    /**
     * @param value Type of the server that represents the environment.
     */
    @JvmName("cobautrkcqtgwwhk")
    public suspend fun type(`value`: Either<String, EnvironmentServerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the server that represents the environment.
     */
    @JvmName("gioyqkbnxlipsulg")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnvironmentServerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the server that represents the environment.
     */
    @JvmName("dfyvxehqjevgrvxd")
    public fun type(`value`: EnvironmentServerType) {
        val toBeMapped = Either.ofRight<String, EnvironmentServerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EnvironmentServerArgs = EnvironmentServerArgs(
        managementPortalUri = managementPortalUri,
        type = type,
    )
}
