@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.ExternalDocumentationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional, external documentation for the API.
 * @property description Description of the documentation.
 * @property title Title of the documentation.
 * @property url URL pointing to the documentation.
 */
public data class ExternalDocumentationArgs(
    public val description: Output<String>? = null,
    public val title: Output<String>? = null,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.ExternalDocumentationArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.ExternalDocumentationArgs =
        com.pulumi.azurenative.apicenter.inputs.ExternalDocumentationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExternalDocumentationArgs].
 */
@PulumiTagMarker
public class ExternalDocumentationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var title: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value Description of the documentation.
     */
    @JvmName("cvfckuijmypxcbwg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Title of the documentation.
     */
    @JvmName("hlosjkpaqlyntnts")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value URL pointing to the documentation.
     */
    @JvmName("vijcnyoqbfrglxkc")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Description of the documentation.
     */
    @JvmName("spjvgfaqvtkoxcgv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Title of the documentation.
     */
    @JvmName("hvomfitnyjhthcat")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value URL pointing to the documentation.
     */
    @JvmName("sgrsatjarifklppx")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ExternalDocumentationArgs = ExternalDocumentationArgs(
        description = description,
        title = title,
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
