@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * API entity.
 * @property contacts The set of contacts
 * @property customProperties The custom metadata defined for API catalog entities.
 * @property description Description of the API.
 * @property externalDocumentation The set of external documentation
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property kind Kind of API. For example, REST or GraphQL.
 * @property license The license information for the API.
 * @property lifecycleStage Current lifecycle stage of the API.
 * @property name The name of the resource
 * @property summary Short description of the API.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property termsOfService Terms of service for the API.
 * @property title API title.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetApiResult(
    public val contacts: List<ContactResponse>? = null,
    public val customProperties: Any? = null,
    public val description: String? = null,
    public val externalDocumentation: List<ExternalDocumentationResponse>? = null,
    public val id: String,
    public val kind: String,
    public val license: LicenseResponse? = null,
    public val lifecycleStage: String,
    public val name: String,
    public val summary: String? = null,
    public val systemData: SystemDataResponse,
    public val termsOfService: TermsOfServiceResponse? = null,
    public val title: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.GetApiResult): GetApiResult = GetApiResult(
            contacts = javaType.contacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apicenter.kotlin.outputs.ContactResponse.Companion.toKotlin(args0)
                })
            }),
            customProperties = javaType.customProperties().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            externalDocumentation = javaType.externalDocumentation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apicenter.kotlin.outputs.ExternalDocumentationResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            kind = javaType.kind(),
            license = javaType.license().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apicenter.kotlin.outputs.LicenseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lifecycleStage = javaType.lifecycleStage(),
            name = javaType.name(),
            summary = javaType.summary().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            termsOfService = javaType.termsOfService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apicenter.kotlin.outputs.TermsOfServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            title = javaType.title(),
            type = javaType.type(),
        )
    }
}
