@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API version entity.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property lifecycleStage Current lifecycle stage of the API.
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property title API version title.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetApiVersionResult(
    public val id: String,
    public val lifecycleStage: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val title: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.GetApiVersionResult): GetApiVersionResult = GetApiVersionResult(
            id = javaType.id(),
            lifecycleStage = javaType.lifecycleStage(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            title = javaType.title(),
            type = javaType.type(),
        )
    }
}
