@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Environment entity.
 * @property customProperties The custom metadata defined for API catalog entities.
 * @property description The environment description.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property kind Environment kind.
 * @property name The name of the resource
 * @property onboarding Environment onboarding information
 * @property server Server information of the environment.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property title Environment title.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEnvironmentResult(
    public val customProperties: Any? = null,
    public val description: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val onboarding: OnboardingResponse? = null,
    public val server: EnvironmentServerResponse? = null,
    public val systemData: SystemDataResponse,
    public val title: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.GetEnvironmentResult): GetEnvironmentResult = GetEnvironmentResult(
            customProperties = javaType.customProperties().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            onboarding = javaType.onboarding().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apicenter.kotlin.outputs.OnboardingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            server = javaType.server().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apicenter.kotlin.outputs.EnvironmentServerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            title = javaType.title(),
            type = javaType.type(),
        )
    }
}
