@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The license information for the API.
 * @property identifier SPDX license information for the API. The identifier field is mutually
 * exclusive of the URL field.
 * @property name Name of the license.
 * @property url URL pointing to the license details. The URL field is mutually exclusive of the
 * identifier field.
 */
public data class LicenseResponse(
    public val identifier: String? = null,
    public val name: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apicenter.outputs.LicenseResponse): LicenseResponse = LicenseResponse(
            identifier = javaType.identifier().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
