@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiIssue].
 */
@PulumiTagMarker
public class ApiIssueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiIssueArgs = ApiIssueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiIssueArgsBuilder.() -> Unit) {
        val builder = ApiIssueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApiIssue {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.ApiIssue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiIssue(builtJavaResource)
    }
}

/**
 * Issue Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiIssue
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiIssue = new AzureNative.ApiManagement.ApiIssue("apiIssue", new()
 *     {
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         CreatedDate = "2018-02-01T22:21:20.467Z",
 *         Description = "New API issue description",
 *         IssueId = "57d2ef278aa04f0ad01d6cdc",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         State = AzureNative.ApiManagement.State.Open,
 *         Title = "New API issue",
 *         UserId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiIssue(ctx, "apiIssue", &apimanagement.ApiIssueArgs{
 * 			ApiId:             pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			CreatedDate:       pulumi.String("2018-02-01T22:21:20.467Z"),
 * 			Description:       pulumi.String("New API issue description"),
 * 			IssueId:           pulumi.String("57d2ef278aa04f0ad01d6cdc"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			State:             pulumi.String(apimanagement.StateOpen),
 * 			Title:             pulumi.String("New API issue"),
 * 			UserId:            pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiIssue;
 * import com.pulumi.azurenative.apimanagement.ApiIssueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiIssue = new ApiIssue("apiIssue", ApiIssueArgs.builder()
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .createdDate("2018-02-01T22:21:20.467Z")
 *             .description("New API issue description")
 *             .issueId("57d2ef278aa04f0ad01d6cdc")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .state("open")
 *             .title("New API issue")
 *             .userId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiIssue 57d2ef278aa04f0ad01d6cdc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}
 * ```
 */
public class ApiIssue internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiIssue,
) : KotlinCustomResource(javaResource, ApiIssueMapper) {
    /**
     * A resource identifier for the API the issue was created for.
     */
    public val apiId: Output<String>?
        get() = javaResource.apiId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Date and time when the issue was created.
     */
    public val createdDate: Output<String>?
        get() = javaResource.createdDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Text describing the issue.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Status of the issue.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The issue title.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A resource identifier for the user created the issue.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object ApiIssueMapper : ResourceMapper<ApiIssue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiIssue::class == javaResource::class

    override fun map(javaResource: Resource): ApiIssue = ApiIssue(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiIssue,
    )
}

/**
 * @see [ApiIssue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiIssue].
 */
public suspend fun apiIssue(name: String, block: suspend ApiIssueResourceBuilder.() -> Unit): ApiIssue {
    val builder = ApiIssueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiIssue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiIssue(name: String): ApiIssue {
    val builder = ApiIssueResourceBuilder()
    builder.name(name)
    return builder.build()
}
