@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiIssueAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Issue Attachment Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiIssueAttachment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiIssueAttachment = new AzureNative.ApiManagement.ApiIssueAttachment("apiIssueAttachment", new()
 *     {
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         AttachmentId = "57d2ef278aa04f0888cba3f3",
 *         Content = "IEJhc2U2NA==",
 *         ContentFormat = "image/jpeg",
 *         IssueId = "57d2ef278aa04f0ad01d6cdc",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Title = "Issue attachment.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiIssueAttachment(ctx, "apiIssueAttachment", &apimanagement.ApiIssueAttachmentArgs{
 * 			ApiId:             pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			AttachmentId:      pulumi.String("57d2ef278aa04f0888cba3f3"),
 * 			Content:           pulumi.String("IEJhc2U2NA=="),
 * 			ContentFormat:     pulumi.String("image/jpeg"),
 * 			IssueId:           pulumi.String("57d2ef278aa04f0ad01d6cdc"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Title:             pulumi.String("Issue attachment."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiIssueAttachment;
 * import com.pulumi.azurenative.apimanagement.ApiIssueAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiIssueAttachment = new ApiIssueAttachment("apiIssueAttachment", ApiIssueAttachmentArgs.builder()
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .attachmentId("57d2ef278aa04f0888cba3f3")
 *             .content("IEJhc2U2NA==")
 *             .contentFormat("image/jpeg")
 *             .issueId("57d2ef278aa04f0ad01d6cdc")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .title("Issue attachment.")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiIssueAttachment 57d2ef278aa04f0888cba3f3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/attachments/{attachmentId}
 * ```
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property attachmentId Attachment identifier within an Issue. Must be unique in the current Issue.
 * @property content An HTTP link or Base64-encoded binary data.
 * @property contentFormat Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided in the 'content' property.
 * @property issueId Issue identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property title Filename by which the binary data will be saved.
 */
public data class ApiIssueAttachmentArgs(
    public val apiId: Output<String>? = null,
    public val attachmentId: Output<String>? = null,
    public val content: Output<String>? = null,
    public val contentFormat: Output<String>? = null,
    public val issueId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiIssueAttachmentArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiIssueAttachmentArgs =
        com.pulumi.azurenative.apimanagement.ApiIssueAttachmentArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .attachmentId(attachmentId?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .contentFormat(contentFormat?.applyValue({ args0 -> args0 }))
            .issueId(issueId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiIssueAttachmentArgs].
 */
@PulumiTagMarker
public class ApiIssueAttachmentArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var attachmentId: Output<String>? = null

    private var content: Output<String>? = null

    private var contentFormat: Output<String>? = null

    private var issueId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("yuavlqhktjctasof")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Attachment identifier within an Issue. Must be unique in the current Issue.
     */
    @JvmName("ryxnrucqrexsfdvr")
    public suspend fun attachmentId(`value`: Output<String>) {
        this.attachmentId = value
    }

    /**
     * @param value An HTTP link or Base64-encoded binary data.
     */
    @JvmName("doraysnqmejmoikj")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided in the 'content' property.
     */
    @JvmName("ljsthhklynltrftl")
    public suspend fun contentFormat(`value`: Output<String>) {
        this.contentFormat = value
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ldlojbilvdbehfnf")
    public suspend fun issueId(`value`: Output<String>) {
        this.issueId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jywcqhiqygborycb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("qcwemlgeieafpdbb")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Filename by which the binary data will be saved.
     */
    @JvmName("qgripoumiighigpf")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("mstdtfkayjlnbxij")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Attachment identifier within an Issue. Must be unique in the current Issue.
     */
    @JvmName("vjhpsjrsribdssjf")
    public suspend fun attachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentId = mapped
    }

    /**
     * @param value An HTTP link or Base64-encoded binary data.
     */
    @JvmName("vroigkjnfilmqobn")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided in the 'content' property.
     */
    @JvmName("rooktavilcguleso")
    public suspend fun contentFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentFormat = mapped
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("qvvrrpuycmvaibjt")
    public suspend fun issueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qndkimckcwujwjyl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("werarvbbsdbcjiov")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Filename by which the binary data will be saved.
     */
    @JvmName("cuqmoirchdpddrfy")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): ApiIssueAttachmentArgs = ApiIssueAttachmentArgs(
        apiId = apiId,
        attachmentId = attachmentId,
        content = content,
        contentFormat = contentFormat,
        issueId = issueId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        title = title,
    )
}
