@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API Schema Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiSchema
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiSchema = new AzureNative.ApiManagement.ApiSchema("apiSchema", new()
 *     {
 *         ApiId = "59d6bb8f1f7fab13dc67ec9b",
 *         ContentType = "application/vnd.ms-azure-apim.xsd+xml",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "ec12520d-9d48-4e7b-8f39-698ca2ac63f1",
 *         ServiceName = "apimService1",
 *         Value = @"<s:schema elementFormDefault=""qualified"" targetNamespace=""http://ws.cdyne.com/WeatherWS/"" xmlns:tns=""http://ws.cdyne.com/WeatherWS/"" xmlns:s=""http://www.w3.org/2001/XMLSchema"" xmlns:soap12=""http://schemas.xmlsoap.org/wsdl/soap12/"" xmlns:mime=""http://schemas.xmlsoap.org/wsdl/mime/"" xmlns:soap=""http://schemas.xmlsoap.org/wsdl/soap/"" xmlns:tm=""http://microsoft.com/wsdl/mime/textMatching/"" xmlns:http=""http://schemas.xmlsoap.org/wsdl/http/"" xmlns:soapenc=""http://schemas.xmlsoap.org/soap/encoding/"" xmlns:wsdl=""http://schemas.xmlsoap.org/wsdl/"" xmlns:apim-wsdltns=""http://ws.cdyne.com/WeatherWS/"">
 *   <s:element name=""GetWeatherInformation"">
 *     <s:complexType />
 *   </s:element>
 *   <s:element name=""GetWeatherInformationResponse"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""0"" maxOccurs=""1"" name=""GetWeatherInformationResult"" type=""tns:ArrayOfWeatherDescription"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name=""ArrayOfWeatherDescription"">
 *     <s:sequence>
 *       <s:element minOccurs=""0"" maxOccurs=""unbounded"" name=""WeatherDescription"" type=""tns:WeatherDescription"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""WeatherDescription"">
 *     <s:sequence>
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""WeatherID"" type=""s:short"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Description"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""PictureURL"" type=""s:string"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name=""GetCityForecastByZIP"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""0"" maxOccurs=""1"" name=""ZIP"" type=""s:string"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name=""GetCityForecastByZIPResponse"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""0"" maxOccurs=""1"" name=""GetCityForecastByZIPResult"" type=""tns:ForecastReturn"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name=""ForecastReturn"">
 *     <s:sequence>
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""Success"" type=""s:boolean"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""ResponseText"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""State"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""City"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""WeatherStationCity"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""ForecastResult"" type=""tns:ArrayOfForecast"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""ArrayOfForecast"">
 *     <s:sequence>
 *       <s:element minOccurs=""0"" maxOccurs=""unbounded"" name=""Forecast"" nillable=""true"" type=""tns:Forecast"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""Forecast"">
 *     <s:sequence>
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""Date"" type=""s:dateTime"" />
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""WeatherID"" type=""s:short"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Desciption"" type=""s:string"" />
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""Temperatures"" type=""tns:temp"" />
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""ProbabilityOfPrecipiation"" type=""tns:POP"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""temp"">
 *     <s:sequence>
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""MorningLow"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""DaytimeHigh"" type=""s:string"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""POP"">
 *     <s:sequence>
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Nighttime"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Daytime"" type=""s:string"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name=""GetCityWeatherByZIP"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""0"" maxOccurs=""1"" name=""ZIP"" type=""s:string"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name=""GetCityWeatherByZIPResponse"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""1"" maxOccurs=""1"" name=""GetCityWeatherByZIPResult"" type=""tns:WeatherReturn"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name=""WeatherReturn"">
 *     <s:sequence>
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""Success"" type=""s:boolean"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""ResponseText"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""State"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""City"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""WeatherStationCity"" type=""s:string"" />
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""WeatherID"" type=""s:short"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Description"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Temperature"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""RelativeHumidity"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Wind"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Pressure"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Visibility"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""WindChill"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Remarks"" type=""s:string"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name=""ArrayOfWeatherDescription"" nillable=""true"" type=""tns:ArrayOfWeatherDescription"" />
 *   <s:element name=""ForecastReturn"" nillable=""true"" type=""tns:ForecastReturn"" />
 *   <s:element name=""WeatherReturn"" type=""tns:WeatherReturn"" />
 * </s:schema>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiSchema(ctx, "apiSchema", &apimanagement.ApiSchemaArgs{
 * 			ApiId:             pulumi.String("59d6bb8f1f7fab13dc67ec9b"),
 * 			ContentType:       pulumi.String("application/vnd.ms-azure-apim.xsd+xml"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("ec12520d-9d48-4e7b-8f39-698ca2ac63f1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<s:schema elementFormDefault="qualified" targetNamespace="http://ws.cdyne.com/WeatherWS/" xmlns:tns="http://ws.cdyne.com/WeatherWS/" xmlns:s="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://schemas.xmlsoap.org/wsdl/soap12/" xmlns:mime="http://schemas.xmlsoap.org/wsdl/mime/" xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" xmlns:tm="http://microsoft.com/wsdl/mime/textMatching/" xmlns:http="http://schemas.xmlsoap.org/wsdl/http/" xmlns:soapenc="http://schemas.xmlsoap.org/soap/encoding/" xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" xmlns:apim-wsdltns="http://ws.cdyne.com/WeatherWS/">
 *   <s:element name="GetWeatherInformation">
 *     <s:complexType />
 *   </s:element>
 *   <s:element name="GetWeatherInformationResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="GetWeatherInformationResult" type="tns:ArrayOfWeatherDescription" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="ArrayOfWeatherDescription">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="unbounded" name="WeatherDescription" type="tns:WeatherDescription" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="WeatherDescription">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Description" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="PictureURL" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="GetCityForecastByZIP">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="ZIP" type="s:string" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name="GetCityForecastByZIPResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="GetCityForecastByZIPResult" type="tns:ForecastReturn" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="ForecastReturn">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Success" type="s:boolean" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ResponseText" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="State" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="City" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WeatherStationCity" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ForecastResult" type="tns:ArrayOfForecast" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="ArrayOfForecast">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="unbounded" name="Forecast" nillable="true" type="tns:Forecast" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="Forecast">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Date" type="s:dateTime" />
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Desciption" type="s:string" />
 *       <s:element minOccurs="1" maxOccurs="1" name="Temperatures" type="tns:temp" />
 *       <s:element minOccurs="1" maxOccurs="1" name="ProbabilityOfPrecipiation" type="tns:POP" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="temp">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="1" name="MorningLow" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="DaytimeHigh" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="POP">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="1" name="Nighttime" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Daytime" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="GetCityWeatherByZIP">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="ZIP" type="s:string" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name="GetCityWeatherByZIPResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="1" maxOccurs="1" name="GetCityWeatherByZIPResult" type="tns:WeatherReturn" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="WeatherReturn">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Success" type="s:boolean" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ResponseText" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="State" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="City" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WeatherStationCity" type="s:string" />
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Description" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Temperature" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="RelativeHumidity" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Wind" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Pressure" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Visibility" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WindChill" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Remarks" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="ArrayOfWeatherDescription" nillable="true" type="tns:ArrayOfWeatherDescription" />
 *   <s:element name="ForecastReturn" nillable="true" type="tns:ForecastReturn" />
 *   <s:element name="WeatherReturn" type="tns:WeatherReturn" />
 * </s:schema>`),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiSchema;
 * import com.pulumi.azurenative.apimanagement.ApiSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiSchema = new ApiSchema("apiSchema", ApiSchemaArgs.builder()
 *             .apiId("59d6bb8f1f7fab13dc67ec9b")
 *             .contentType("application/vnd.ms-azure-apim.xsd+xml")
 *             .resourceGroupName("rg1")
 *             .schemaId("ec12520d-9d48-4e7b-8f39-698ca2ac63f1")
 *             .serviceName("apimService1")
 *             .value("""
 * <s:schema elementFormDefault="qualified" targetNamespace="http://ws.cdyne.com/WeatherWS/" xmlns:tns="http://ws.cdyne.com/WeatherWS/" xmlns:s="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://schemas.xmlsoap.org/wsdl/soap12/" xmlns:mime="http://schemas.xmlsoap.org/wsdl/mime/" xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" xmlns:tm="http://microsoft.com/wsdl/mime/textMatching/" xmlns:http="http://schemas.xmlsoap.org/wsdl/http/" xmlns:soapenc="http://schemas.xmlsoap.org/soap/encoding/" xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" xmlns:apim-wsdltns="http://ws.cdyne.com/WeatherWS/">
 *   <s:element name="GetWeatherInformation">
 *     <s:complexType />
 *   </s:element>
 *   <s:element name="GetWeatherInformationResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="GetWeatherInformationResult" type="tns:ArrayOfWeatherDescription" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="ArrayOfWeatherDescription">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="unbounded" name="WeatherDescription" type="tns:WeatherDescription" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="WeatherDescription">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Description" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="PictureURL" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="GetCityForecastByZIP">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="ZIP" type="s:string" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name="GetCityForecastByZIPResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="GetCityForecastByZIPResult" type="tns:ForecastReturn" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="ForecastReturn">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Success" type="s:boolean" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ResponseText" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="State" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="City" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WeatherStationCity" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ForecastResult" type="tns:ArrayOfForecast" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="ArrayOfForecast">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="unbounded" name="Forecast" nillable="true" type="tns:Forecast" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="Forecast">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Date" type="s:dateTime" />
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Desciption" type="s:string" />
 *       <s:element minOccurs="1" maxOccurs="1" name="Temperatures" type="tns:temp" />
 *       <s:element minOccurs="1" maxOccurs="1" name="ProbabilityOfPrecipiation" type="tns:POP" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="temp">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="1" name="MorningLow" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="DaytimeHigh" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="POP">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="1" name="Nighttime" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Daytime" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="GetCityWeatherByZIP">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="ZIP" type="s:string" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name="GetCityWeatherByZIPResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="1" maxOccurs="1" name="GetCityWeatherByZIPResult" type="tns:WeatherReturn" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="WeatherReturn">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Success" type="s:boolean" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ResponseText" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="State" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="City" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WeatherStationCity" type="s:string" />
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Description" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Temperature" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="RelativeHumidity" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Wind" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Pressure" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Visibility" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WindChill" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Remarks" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="ArrayOfWeatherDescription" nillable="true" type="tns:ArrayOfWeatherDescription" />
 *   <s:element name="ForecastReturn" nillable="true" type="tns:ForecastReturn" />
 *   <s:element name="WeatherReturn" type="tns:WeatherReturn" />
 * </s:schema>            """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiSchema ec12520d-9d48-4e7b-8f39-698ca2ac63f1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/schemas/{schemaId}
 * ```
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property components Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
 * @property contentType Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema document (e.g. application/json, application/xml). </br> - `Swagger` Schema use `application/vnd.ms-azure-apim.swagger.definitions+json` </br> - `WSDL` Schema use `application/vnd.ms-azure-apim.xsd+xml` </br> - `OpenApi` Schema use `application/vnd.oai.openapi.components+json` </br> - `WADL Schema` use `application/vnd.ms-azure-apim.wadl.grammars+xml`.
 * @property definitions Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schemaId Schema id identifier. Must be unique in the current API Management service instance.
 * @property serviceName The name of the API Management service.
 * @property value Json escaped string defining the document representing the Schema. Used for schemas other than Swagger/OpenAPI.
 */
public data class ApiSchemaArgs(
    public val apiId: Output<String>? = null,
    public val components: Output<Any>? = null,
    public val contentType: Output<String>? = null,
    public val definitions: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaId: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiSchemaArgs =
        com.pulumi.azurenative.apimanagement.ApiSchemaArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .components(components?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .definitions(definitions?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaId(schemaId?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiSchemaArgs].
 */
@PulumiTagMarker
public class ApiSchemaArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var components: Output<Any>? = null

    private var contentType: Output<String>? = null

    private var definitions: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaId: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("fjqyssneadcstxyr")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     */
    @JvmName("vfwgqlhkpitrpajl")
    public suspend fun components(`value`: Output<Any>) {
        this.components = value
    }

    /**
     * @param value Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema document (e.g. application/json, application/xml). </br> - `Swagger` Schema use `application/vnd.ms-azure-apim.swagger.definitions+json` </br> - `WSDL` Schema use `application/vnd.ms-azure-apim.xsd+xml` </br> - `OpenApi` Schema use `application/vnd.oai.openapi.components+json` </br> - `WADL Schema` use `application/vnd.ms-azure-apim.wadl.grammars+xml`.
     */
    @JvmName("ephuvvecbbjxbpsc")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     */
    @JvmName("xjngmdhytrwxexef")
    public suspend fun definitions(`value`: Output<Any>) {
        this.definitions = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uwiwvsvijoxdweow")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("hqeqyrayinxloqxv")
    public suspend fun schemaId(`value`: Output<String>) {
        this.schemaId = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("wkfsdqtoggcbvvcu")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Json escaped string defining the document representing the Schema. Used for schemas other than Swagger/OpenAPI.
     */
    @JvmName("xbjarnftwkahbsfd")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("cmiqcjexwinoqwov")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     */
    @JvmName("jcbdwuwxscdameai")
    public suspend fun components(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param value Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema document (e.g. application/json, application/xml). </br> - `Swagger` Schema use `application/vnd.ms-azure-apim.swagger.definitions+json` </br> - `WSDL` Schema use `application/vnd.ms-azure-apim.xsd+xml` </br> - `OpenApi` Schema use `application/vnd.oai.openapi.components+json` </br> - `WADL Schema` use `application/vnd.ms-azure-apim.wadl.grammars+xml`.
     */
    @JvmName("rrfbsarvpebnywas")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     */
    @JvmName("xhwerhpqybglmmpb")
    public suspend fun definitions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definitions = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("knirhnimdfnbcamt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("wkgcqvnknsnrcmxh")
    public suspend fun schemaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaId = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("bhogatdmjhwthabo")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Json escaped string defining the document representing the Schema. Used for schemas other than Swagger/OpenAPI.
     */
    @JvmName("sbyewqntgfbwvgkp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ApiSchemaArgs = ApiSchemaArgs(
        apiId = apiId,
        components = components,
        contentType = contentType,
        definitions = definitions,
        resourceGroupName = resourceGroupName,
        schemaId = schemaId,
        serviceName = serviceName,
        `value` = `value`,
    )
}
