@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendCredentialsContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendPropertiesResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendProxyContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendTlsPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendCredentialsContractResponse.Companion.toKotlin as backendCredentialsContractResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendPropertiesResponse.Companion.toKotlin as backendPropertiesResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendProxyContractResponse.Companion.toKotlin as backendProxyContractResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.BackendTlsPropertiesResponse.Companion.toKotlin as backendTlsPropertiesResponseToKotlin

/**
 * Builder for [Backend].
 */
@PulumiTagMarker
public class BackendResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackendArgs = BackendArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackendArgsBuilder.() -> Unit) {
        val builder = BackendArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Backend {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.Backend(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Backend(builtJavaResource)
    }
}

/**
 * Backend details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2018-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateBackendProxyBackend
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backend = new AzureNative.ApiManagement.Backend("backend", new()
 *     {
 *         BackendId = "proxybackend",
 *         Credentials = new AzureNative.ApiManagement.Inputs.BackendCredentialsContractArgs
 *         {
 *             Authorization = new AzureNative.ApiManagement.Inputs.BackendAuthorizationHeaderCredentialsArgs
 *             {
 *                 Parameter = "opensesma",
 *                 Scheme = "Basic",
 *             },
 *             Header =
 *             {
 *                 { "x-my-1", new[]
 *                 {
 *                     "val1",
 *                     "val2",
 *                 } },
 *             },
 *             Query =
 *             {
 *                 { "sv", new[]
 *                 {
 *                     "xx",
 *                     "bb",
 *                     "cc",
 *                 } },
 *             },
 *         },
 *         Description = "description5308",
 *         Protocol = AzureNative.ApiManagement.BackendProtocol.Http,
 *         Proxy = new AzureNative.ApiManagement.Inputs.BackendProxyContractArgs
 *         {
 *             Password = "<password>",
 *             Url = "http://192.168.1.1:8080",
 *             Username = "Contoso\\admin",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Tls = new AzureNative.ApiManagement.Inputs.BackendTlsPropertiesArgs
 *         {
 *             ValidateCertificateChain = true,
 *             ValidateCertificateName = true,
 *         },
 *         Url = "https://backendname2644/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewBackend(ctx, "backend", &apimanagement.BackendArgs{
 * 			BackendId: pulumi.String("proxybackend"),
 * 			Credentials: &apimanagement.BackendCredentialsContractArgs{
 * 				Authorization: &apimanagement.BackendAuthorizationHeaderCredentialsArgs{
 * 					Parameter: pulumi.String("opensesma"),
 * 					Scheme:    pulumi.String("Basic"),
 * 				},
 * 				Header: pulumi.StringArrayMap{
 * 					"x-my-1": pulumi.StringArray{
 * 						pulumi.String("val1"),
 * 						pulumi.String("val2"),
 * 					},
 * 				},
 * 				Query: pulumi.StringArrayMap{
 * 					"sv": pulumi.StringArray{
 * 						pulumi.String("xx"),
 * 						pulumi.String("bb"),
 * 						pulumi.String("cc"),
 * 					},
 * 				},
 * 			},
 * 			Description: pulumi.String("description5308"),
 * 			Protocol:    pulumi.String(apimanagement.BackendProtocolHttp),
 * 			Proxy: &apimanagement.BackendProxyContractArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Url:      pulumi.String("http://192.168.1.1:8080"),
 * 				Username: pulumi.String("Contoso\\admin"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Tls: &apimanagement.BackendTlsPropertiesArgs{
 * 				ValidateCertificateChain: pulumi.Bool(true),
 * 				ValidateCertificateName:  pulumi.Bool(true),
 * 			},
 * 			Url: pulumi.String("https://backendname2644/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Backend;
 * import com.pulumi.azurenative.apimanagement.BackendArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.BackendCredentialsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.BackendAuthorizationHeaderCredentialsArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.BackendProxyContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.BackendTlsPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backend = new Backend("backend", BackendArgs.builder()
 *             .backendId("proxybackend")
 *             .credentials(BackendCredentialsContractArgs.builder()
 *                 .authorization(BackendAuthorizationHeaderCredentialsArgs.builder()
 *                     .parameter("opensesma")
 *                     .scheme("Basic")
 *                     .build())
 *                 .header(Map.of("x-my-1",
 *                     "val1",
 *                     "val2"))
 *                 .query(Map.of("sv",
 *                     "xx",
 *                     "bb",
 *                     "cc"))
 *                 .build())
 *             .description("description5308")
 *             .protocol("http")
 *             .proxy(BackendProxyContractArgs.builder()
 *                 .password("<password>")
 *                 .url("http://192.168.1.1:8080")
 *                 .username("Contoso\\admin")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tls(BackendTlsPropertiesArgs.builder()
 *                 .validateCertificateChain(true)
 *                 .validateCertificateName(true)
 *                 .build())
 *             .url("https://backendname2644/")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateBackendServiceFabric
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backend = new AzureNative.ApiManagement.Backend("backend", new()
 *     {
 *         BackendId = "sfbackend",
 *         Description = "Service Fabric Test App 1",
 *         Properties = new AzureNative.ApiManagement.Inputs.BackendPropertiesArgs
 *         {
 *             ServiceFabricCluster = new AzureNative.ApiManagement.Inputs.BackendServiceFabricClusterPropertiesArgs
 *             {
 *                 ClientCertificateId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1",
 *                 ManagementEndpoints = new[]
 *                 {
 *                     "https://somecluster.com",
 *                 },
 *                 MaxPartitionResolutionRetries = 5,
 *                 ServerX509Names = new[]
 *                 {
 *                     new AzureNative.ApiManagement.Inputs.X509CertificateNameArgs
 *                     {
 *                         IssuerCertificateThumbprint = "IssuerCertificateThumbprint1",
 *                         Name = "ServerCommonName1",
 *                     },
 *                 },
 *             },
 *         },
 *         Protocol = AzureNative.ApiManagement.BackendProtocol.Http,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Url = "fabric:/mytestapp/mytestservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewBackend(ctx, "backend", &apimanagement.BackendArgs{
 * 			BackendId:   pulumi.String("sfbackend"),
 * 			Description: pulumi.String("Service Fabric Test App 1"),
 * 			Properties: &apimanagement.BackendPropertiesArgs{
 * 				ServiceFabricCluster: &apimanagement.BackendServiceFabricClusterPropertiesArgs{
 * 					ClientCertificateId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1"),
 * 					ManagementEndpoints: pulumi.StringArray{
 * 						pulumi.String("https://somecluster.com"),
 * 					},
 * 					MaxPartitionResolutionRetries: pulumi.Int(5),
 * 					ServerX509Names: apimanagement.X509CertificateNameArray{
 * 						&apimanagement.X509CertificateNameArgs{
 * 							IssuerCertificateThumbprint: pulumi.String("IssuerCertificateThumbprint1"),
 * 							Name:                        pulumi.String("ServerCommonName1"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Protocol:          pulumi.String(apimanagement.BackendProtocolHttp),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Url:               pulumi.String("fabric:/mytestapp/mytestservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Backend;
 * import com.pulumi.azurenative.apimanagement.BackendArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.BackendPropertiesArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.BackendServiceFabricClusterPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backend = new Backend("backend", BackendArgs.builder()
 *             .backendId("sfbackend")
 *             .description("Service Fabric Test App 1")
 *             .properties(BackendPropertiesArgs.builder()
 *                 .serviceFabricCluster(BackendServiceFabricClusterPropertiesArgs.builder()
 *                     .clientCertificateId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1")
 *                     .managementEndpoints("https://somecluster.com")
 *                     .maxPartitionResolutionRetries(5)
 *                     .serverX509Names(X509CertificateNameArgs.builder()
 *                         .issuerCertificateThumbprint("IssuerCertificateThumbprint1")
 *                         .name("ServerCommonName1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .protocol("http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .url("fabric:/mytestapp/mytestservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Backend sfbackend /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends/{backendId}
 * ```
 */
public class Backend internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.Backend,
) : KotlinCustomResource(javaResource, BackendMapper) {
    /**
     * Backend Credentials Contract Properties
     */
    public val credentials: Output<BackendCredentialsContractResponse>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    backendCredentialsContractResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Backend Description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Backend Properties contract
     */
    public val properties: Output<BackendPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                backendPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Backend communication protocol.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * Backend gateway Contract Properties
     */
    public val proxy: Output<BackendProxyContractResponse>?
        get() = javaResource.proxy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    backendProxyContractResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or API Apps.
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Backend Title.
     */
    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Backend TLS Properties
     */
    public val tls: Output<BackendTlsPropertiesResponse>?
        get() = javaResource.tls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    backendTlsPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Runtime Url of the Backend.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object BackendMapper : ResourceMapper<Backend> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.Backend::class == javaResource::class

    override fun map(javaResource: Resource): Backend = Backend(
        javaResource as
            com.pulumi.azurenative.apimanagement.Backend,
    )
}

/**
 * @see [Backend].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Backend].
 */
public suspend fun backend(name: String, block: suspend BackendResourceBuilder.() -> Unit): Backend {
    val builder = BackendResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Backend].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backend(name: String): Backend {
    val builder = BackendResourceBuilder()
    builder.name(name)
    return builder.build()
}
