@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Cache].
 */
@PulumiTagMarker
public class CacheResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CacheArgs = CacheArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CacheArgsBuilder.() -> Unit) {
        val builder = CacheArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cache {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.Cache(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cache(builtJavaResource)
    }
}

/**
 * Cache details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-12-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateCache
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cache = new AzureNative.ApiManagement.Cache("cache", new()
 *     {
 *         CacheId = "c1",
 *         ConnectionString = "apim.redis.cache.windows.net:6380,password=xc,ssl=True,abortConnect=False",
 *         Description = "Redis cache instances in West India",
 *         ResourceGroupName = "rg1",
 *         ResourceId = "https://management.azure.com/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/redis/apimservice1",
 *         ServiceName = "apimService1",
 *         UseFromLocation = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewCache(ctx, "cache", &apimanagement.CacheArgs{
 * 			CacheId:           pulumi.String("c1"),
 * 			ConnectionString:  pulumi.String("apim.redis.cache.windows.net:6380,password=xc,ssl=True,abortConnect=False"),
 * 			Description:       pulumi.String("Redis cache instances in West India"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceId:        pulumi.String("https://management.azure.com/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/redis/apimservice1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			UseFromLocation:   pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Cache;
 * import com.pulumi.azurenative.apimanagement.CacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cache = new Cache("cache", CacheArgs.builder()
 *             .cacheId("c1")
 *             .connectionString("apim.redis.cache.windows.net:6380,password=xc,ssl=True,abortConnect=False")
 *             .description("Redis cache instances in West India")
 *             .resourceGroupName("rg1")
 *             .resourceId("https://management.azure.com/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/redis/apimservice1")
 *             .serviceName("apimService1")
 *             .useFromLocation("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Cache c1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/caches/{cacheId}
 * ```
 */
public class Cache internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.Cache,
) : KotlinCustomResource(javaResource, CacheMapper) {
    /**
     * Runtime connection string to cache
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * Cache description
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Original uri of entity in external system cache points to
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
     */
    public val useFromLocation: Output<String>
        get() = javaResource.useFromLocation().applyValue({ args0 -> args0 })
}

public object CacheMapper : ResourceMapper<Cache> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.Cache::class == javaResource::class

    override fun map(javaResource: Resource): Cache = Cache(
        javaResource as
            com.pulumi.azurenative.apimanagement.Cache,
    )
}

/**
 * @see [Cache].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cache].
 */
public suspend fun cache(name: String, block: suspend CacheResourceBuilder.() -> Unit): Cache {
    val builder = CacheResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cache].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cache(name: String): Cache {
    val builder = CacheResourceBuilder()
    builder.name(name)
    return builder.build()
}
